/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.StatueEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.items.ChiselItem;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class StatueUpdatePacket
extends AbstractPixelmonPacket {
    private EnumStatuePacketMode mode;
    private UUID id;
    private String name;
    private boolean data;
    private int intData;

    public StatueUpdatePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public StatueUpdatePacket(EnumStatuePacketMode mode, UUID id, String name) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.name = name;
    }

    public StatueUpdatePacket(EnumStatuePacketMode mode, UUID id, boolean data) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.data = data;
    }

    public StatueUpdatePacket(EnumStatuePacketMode mode, UUID id, int intData) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.intData = intData;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.mode = EnumStatuePacketMode.getFromOrdinal(buf.readShort());
        this.id = buf.func_179253_g();
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: 
            case SetPalette: 
            case SetBoundingBoxMode: 
            case SetForm: {
                this.name = buf.func_218666_n();
                break;
            }
            case SetShouldAnimate: 
            case SetModelStanding: 
            case SetCanMove: {
                this.data = buf.readBoolean();
                break;
            }
            case SetAnimationFrame: 
            case SetGender: {
                this.intData = buf.readInt();
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeShort((int)((short)this.mode.ordinal()));
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: 
            case SetPalette: 
            case SetBoundingBoxMode: 
            case SetForm: {
                buf.func_180714_a(this.name);
                break;
            }
            case SetShouldAnimate: 
            case SetModelStanding: 
            case SetCanMove: {
                buf.writeBoolean(this.data);
                break;
            }
            case SetAnimationFrame: 
            case SetGender: {
                buf.writeInt(this.intData);
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        if (!ChiselItem.checkPermission(sender)) {
            return;
        }
        StatueEntity statue = WorldHelper.getEntityByUUID(sender.func_71121_q(), this.id, StatueEntity.class);
        if (statue == null) {
            return;
        }
        Object value = this.mode.chooseValueForMode(this.name, this.data, this.intData);
        StatueEvent.ModifyStatue modifyEvent = new StatueEvent.ModifyStatue(sender, statue, this.mode, value);
        if (Pixelmon.EVENT_BUS.post((Event)modifyEvent)) {
            sender.func_71053_j();
            return;
        }
        value = modifyEvent.getValue();
        switch (this.mode) {
            case SetCanMove: {
                statue.setCanMove((Boolean)value);
                break;
            }
            case SetBoundingBoxMode: {
                statue.setBoundingMode(EnumBoundingBoxMode.valueOf(this.name));
                break;
            }
            case SetPalette: {
                statue.setPalette(this.name);
                break;
            }
            case SetName: {
                statue.setPokemon(PokemonFactory.create((Species)value));
                break;
            }
            case SetGrowth: {
                statue.setGrowth((EnumGrowth)value);
                break;
            }
            case SetLabel: {
                statue.setLabel((String)value);
                break;
            }
            case SetTextureType: {
                statue.setTextureType(EnumStatueTextureType.getFromString((String)value));
                break;
            }
            case SetAnimation: {
                statue.setAnimation(AnimationType.getTypeFor((String)value));
                break;
            }
            case SetModelStanding: {
                statue.setIsFlying((Boolean)value);
                break;
            }
            case SetAnimationFrame: {
                statue.setAnimationFrame((Integer)value);
                break;
            }
            case SetForm: {
                statue.setForm(statue.getSpecies().getForm((String)value));
                break;
            }
            case SetGender: {
                statue.setGender(Gender.values()[(Integer)value]);
                break;
            }
            case SetShouldAnimate: {
                statue.setAnimated((Boolean)value);
            }
        }
    }
}

