/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.raids;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidCatchScreen;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ReturnBagItemsPacket;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenRaidDropsPacket
extends ReturnBagItemsPacket {
    private boolean canCatch;
    private RaidData raid;
    private List<ItemStack> drops = Lists.newArrayList();

    public OpenRaidDropsPacket() {
        super(true);
    }

    public OpenRaidDropsPacket(boolean canCatch, RaidData raid, RaidData.RaidPlayer player, List<ItemData> itemData) {
        super(BagSection.POKEBALLS, itemData);
        this.canCatch = canCatch;
        this.raid = raid;
        this.drops = player.drops;
    }

    @Override
    public void decode(PacketBuffer buf) {
        super.decode(buf);
        this.canCatch = buf.readBoolean();
        this.raid = new RaidData(buf);
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.drops.add(buf.func_150791_c());
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        super.encode(buf);
        buf.writeBoolean(this.canCatch);
        this.raid.write(buf);
        buf.writeInt(this.drops.size());
        for (ItemStack stack : this.drops) {
            buf.func_150788_a(stack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacket(NetworkEvent.Context context) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.execute(() -> {
            if (mc.field_71462_r instanceof BattleScreen) {
                ((BattleScreen)mc.field_71462_r).restoreSettingsAndClose();
            }
            mc.execute(() -> mc.func_147108_a((Screen)new RaidCatchScreen(this.raid, false, this.drops.toArray(new ItemStack[0]), this.itemData, this.canCatch)));
        });
    }
}

