/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.DeletePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPartyPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdatePlayerPokemonPacket;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdatePlayerPartyPacket
extends UpdateEditedPartyPacket {
    private UUID playerID;

    public UpdatePlayerPartyPacket() {
    }

    public UpdatePlayerPartyPacket(List<Pokemon> party) {
        super(party);
    }

    @Override
    protected UpdateEditedPokemonPacket createPokemonPacket(Pokemon data) {
        return new UpdatePlayerPokemonPacket(data);
    }

    @Override
    protected UpdateEditedPokemonPacket readPokemonData(PacketBuffer buf) {
        UpdatePlayerPokemonPacket data = new UpdatePlayerPokemonPacket();
        data.decode(buf);
        this.playerID = data.data.getOwnerPlayerUUID();
        return data;
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (!PokemonEditorItem.checkPermission(context.getSender())) {
            return;
        }
        for (int i = 0; i < this.party.size(); ++i) {
            UpdatePlayerPokemonPacket data = (UpdatePlayerPokemonPacket)this.party.get(i);
            PlayerPartyStorage party = StorageProxy.getParty(this.playerID);
            if (data == null) {
                if (party.get(i) == null) continue;
                DeletePokemonPacket.deletePokemon(this.playerID, i, context);
                continue;
            }
            int slot = i;
            party.doWithoutSendingUpdates(() -> party.set(slot, null));
            data.handle(context);
        }
    }
}

