/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.events.ShopkeeperEvent;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.EnumBuySell;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ShopKeeperPacket
extends AbstractPixelmonPacket {
    private EnumBuySell buySell;
    private String itemID;
    private int amount;
    private int shopKeeperID;

    public ShopKeeperPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ShopKeeperPacket(EnumBuySell buySell, int shopkeeperID, String itemID, int amount) {
        super(PacketDirection.PLAY_SERVER, true);
        this.shopKeeperID = shopkeeperID;
        this.itemID = itemID;
        this.amount = amount;
        this.buySell = buySell;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.buySell = buf.readBoolean() ? EnumBuySell.Buy : EnumBuySell.Sell;
        this.shopKeeperID = buf.readInt();
        this.itemID = buf.func_218666_n();
        this.amount = buf.readInt();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.buySell == EnumBuySell.Buy);
        buf.writeInt(this.shopKeeperID);
        buf.func_180714_a(this.itemID);
        buf.writeInt(this.amount);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity p = context.getSender();
        Optional<NPCShopkeeper> npcOptional = NPCEntity.locateNPCServer(p.field_70170_p, this.shopKeeperID, NPCShopkeeper.class);
        BankAccount account = BankAccountProxy.getBankAccount(p).orElse(null);
        if (!npcOptional.isPresent() || this.amount <= 0 || account == null) {
            return;
        }
        NPCShopkeeper npc = npcOptional.get();
        if (this.buySell == EnumBuySell.Buy) {
            ArrayList<ShopItemWithVariation> itemList = npc.getItemList();
            for (ShopItemWithVariation shopItem : itemList) {
                if (!shopItem.getBaseShopItem().id.equals(this.itemID)) continue;
                if (this.amount > PixelmonConfigProxy.getGeneral().getShopMaxStackSize(shopItem.getItemStack())) {
                    return;
                }
                if (!(account.getBalance().doubleValue() >= (double)(shopItem.getBuyCost() * this.amount))) continue;
                if (shopItem.getBuyCost() * this.amount < 0) {
                    return;
                }
                BigInteger total = BigInteger.valueOf(this.amount).multiply(BigInteger.valueOf(shopItem.getBuyCost()));
                if (total.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                    Pixelmon.LOGGER.error("Integer overflow whilst purchasing item from " + npc.func_200200_C_() + " player: " + p.func_200200_C_());
                    return;
                }
                ItemStack item = shopItem.getItemStack();
                ItemStack buyStack = item.func_77946_l();
                int initialAmount = this.amount;
                buyStack.func_190920_e(this.amount);
                if (Pixelmon.EVENT_BUS.post((Event)new ShopkeeperEvent.Purchase(p, npc, buyStack, EnumBuySell.Buy))) {
                    return;
                }
                if (p.func_191521_c(buyStack)) {
                    Item buyItem = item.func_77973_b();
                    PokeBall pokeBall = PokeBallPart.getPokeBall(buyStack).orElse(null);
                    if (buyItem instanceof PokeBallItem && PokeBallRegistry.POKE_BALL.getValueUnsafe().is(pokeBall) && this.amount >= 10) {
                        ItemStack premierBall = PokeBallRegistry.PREMIER_BALL.getValueUnsafe().getBallItem();
                        p.func_191521_c(premierBall);
                    }
                    if (buyItem == Items.field_190931_a) continue;
                    account.take(shopItem.getBuyCost() * this.amount);
                    this.updateTransaction(p, npc);
                    continue;
                }
                if (initialAmount <= buyStack.func_190916_E()) continue;
                int actualAmount = initialAmount - buyStack.func_190916_E();
                account.take(shopItem.getBuyCost() * actualAmount);
                this.updateTransaction(p, npc);
            }
        } else {
            ArrayList<ShopItemWithVariation> sellList = npc.getSellList((PlayerEntity)p);
            for (ShopItemWithVariation shopItem : sellList) {
                if (!shopItem.getBaseShopItem().id.equals(this.itemID)) continue;
                int count = 0;
                ItemStack sStack = shopItem.getItemStack();
                for (int i = 0; i < p.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack item = (ItemStack)p.field_71071_by.field_70462_a.get(i);
                    if (!this.areItemsEqual(item, sStack)) continue;
                    count += item.func_190916_E();
                }
                ItemStack copy = sStack.func_77946_l();
                copy.func_190920_e(this.amount);
                if (Pixelmon.EVENT_BUS.post((Event)new ShopkeeperEvent.Sell(p, npc, EnumBuySell.Sell, copy))) {
                    return;
                }
                if (count < this.amount) continue;
                int cost = shopItem.getSellCost();
                count = this.amount;
                BigInteger total = BigInteger.valueOf(this.amount).multiply(BigInteger.valueOf(shopItem.getSellCost()));
                if (total.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                    Pixelmon.LOGGER.error("Integer overflow whilst selling item to " + npc.func_200200_C_() + " player: " + p.func_200200_C_());
                    return;
                }
                for (int i = 0; i < p.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack item = (ItemStack)p.field_71071_by.field_70462_a.get(i);
                    if (this.areItemsEqual(item, sStack)) {
                        if (item.func_190916_E() >= count) {
                            item.func_190920_e(item.func_190916_E() - count);
                            count = 0;
                        } else {
                            count -= item.func_190916_E();
                            item.func_190920_e(0);
                        }
                        if (item.func_190916_E() == 0) {
                            p.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                        }
                    }
                    if (count <= 0) break;
                }
                account.add(cost * this.amount);
                this.updateTransaction(p, npc);
            }
        }
    }

    private void updateTransaction(ServerPlayerEntity p, NPCShopkeeper npc) {
        p.field_71069_bz.func_75142_b();
        npc.sendItemsToPlayer((PlayerEntity)p);
    }

    private boolean areItemsEqual(ItemStack item1, ItemStack item2) {
        return !item1.func_190926_b() && ItemStack.func_179545_c((ItemStack)item1, (ItemStack)item2) && ItemStack.func_77970_a((ItemStack)item1, (ItemStack)item2) && item1.func_77952_i() == item2.func_77952_i();
    }
}

