/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.camera;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.CameraEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.BufferHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ItemCameraPacket
extends AbstractPixelmonPacket {
    private int entityId;

    public ItemCameraPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ItemCameraPacket(int entityID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.entityId = entityID;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.entityId = BufferHelper.readVarInt(buf, 4);
    }

    @Override
    public void encode(PacketBuffer buf) {
        BufferHelper.writeVarInt((ByteBuf)buf, this.entityId, 4);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PixelmonEntity pixelmon = (PixelmonEntity)player.field_70170_p.func_73045_a(this.entityId);
        if (pixelmon == null) {
            return;
        }
        if (!PixelmonConfigProxy.getBattle().isMultiplePhotosOfSamePokemon() && pixelmon.cameraCapturedPlayers.contains(player.func_110124_au()) && !Pixelmon.EVENT_BUS.post((Event)new CameraEvent.DuplicatePhoto(player, pixelmon))) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("camera.error.samepokemon", new Object[]{pixelmon.getLocalizedName()}), Util.field_240973_b_);
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new CameraEvent.ConsumeFilm(player, pixelmon)) || this.clearMatchingItems(player, PixelmonItems.film) == 1) {
            ItemStack photo;
            CameraEvent.TakePhoto event;
            if (!PixelmonConfigProxy.getBattle().isMultiplePhotosOfSamePokemon()) {
                pixelmon.cameraCapturedPlayers.add(player.func_110124_au());
            }
            if (!Pixelmon.EVENT_BUS.post((Event)(event = new CameraEvent.TakePhoto(player, pixelmon, photo = SpriteItemHelper.getPhoto(pixelmon.getPokemon()))))) {
                player.field_71071_by.func_70441_a(event.photo);
                pixelmon.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)SoundRegistration.CAMERA_SHUTTER.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
            }
        }
    }

    private int clearMatchingItems(ServerPlayerEntity player, Item item) {
        int slotMatchingUnusedItem = player.field_71071_by.func_194014_c(new ItemStack((IItemProvider)item));
        if (slotMatchingUnusedItem == -1) {
            return 0;
        }
        ItemStack found = player.field_71071_by.func_70301_a(slotMatchingUnusedItem);
        if (found == ItemStack.field_190927_a) {
            return 0;
        }
        found.func_190918_g(1);
        return 1;
    }
}

