/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models;

import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimationSequence;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public abstract class PixelmonModelSmd<M extends Entity>
extends PixelmonModelBase<M> {
    public float animationIncrement = 1.0f;
    public ValveStudioModel theModel;
    public float partialTick;

    public PixelmonModelSmd() {
        this.registerAnimationCounters();
    }

    public ValveStudioModel getTheModel() {
        return this.theModel;
    }

    @Override
    public float getScale() {
        return this.theModel.getScale();
    }

    public void setupForRender(AbstractClientEntity pixelmon) {
        this.setAnimation(pixelmon.getCurrentAnimation());
        IncrementingVariable counter = this.getCounter(-1, (Entity)pixelmon);
        if (counter == null) {
            counter = this.setCounter(-1, 2.1474836E9f, this.animationIncrement, (Entity)pixelmon);
        }
        this.updateAnimation(counter);
    }

    protected void updateAnimation(IncrementingVariable variable) {
        SmdAnimationSequence sequence = this.theModel.currentSequence;
        if (sequence != null) {
            SmdAnimation animation = sequence.checkForIncrement(variable);
            int frame = (int)Math.floor(variable.value % (float)animation.totalFrames);
            if (variable.shouldReverse && variable.value >= (float)animation.totalFrames) {
                variable.inReverse = true;
                if (variable.shouldStayAtEnd) {
                    variable.setAtEnd(true);
                }
                frame = animation.totalFrames - 1;
            }
            animation.setCurrentFrame(MathHelper.func_76125_a((int)frame, (int)0, (int)(animation.totalFrames - 1)));
        }
        this.theModel.animate();
    }

    protected void setAnimation(AnimationType animType) {
        this.theModel.setAnimation(animType);
    }

    @Override
    protected void setInt(int id, int value, Entity pixelmon) {
        if (pixelmon instanceof AbstractClientEntity) {
            ((AbstractClientEntity)pixelmon).getAnimationVariables().setInt(id, value);
        }
    }

    @Override
    protected int getInt(int id, Entity pixelmon) {
        if (pixelmon instanceof AbstractClientEntity) {
            return ((AbstractClientEntity)pixelmon).getAnimationVariables().getInt(id);
        }
        return -1;
    }

    protected IncrementingVariable setCounter(int id, float limit, float increment, Entity pixelmon) {
        if (pixelmon instanceof AbstractClientEntity) {
            return ((AbstractClientEntity)pixelmon).getAnimationVariables().setCounter(id, limit, increment);
        }
        return null;
    }

    @Override
    protected IncrementingVariable getCounter(int id, Entity pixelmon) {
        if (!(pixelmon instanceof AbstractClientEntity)) {
            return null;
        }
        return ((AbstractClientEntity)pixelmon).getAnimationVariables().getCounter(id);
    }

    @Override
    protected void registerAnimationCounters() {
    }
}

