/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IndividualEditorBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PokemonEditorAdvancedScreen
extends DropDownScreen {
    private IndividualEditorBaseScreen previousScreen;
    private Pokemon data;
    private TextFieldWidget[] evText = new TextFieldWidget[6];
    private TextFieldWidget[] ivText = new TextFieldWidget[6];
    private BattleStatsType[] stats = new BattleStatsType[]{BattleStatsType.HP, BattleStatsType.ATTACK, BattleStatsType.DEFENSE, BattleStatsType.SPECIAL_ATTACK, BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.SPEED};
    private TextFieldWidget heldText;
    private ItemStack heldItem = ItemStack.field_190927_a;
    private TextFieldWidget natureText;
    private TextFieldWidget friendshipText;
    private DropDown<String> abilityDropDown;
    private TextFieldWidget[] allText;
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_MAX_IVS = 3;
    private static final int BUTTON_MIN_IVS = 4;
    private static final int BUTTON_RANDOM_IVS = 5;
    private static final int BUTTON_RESET_EVS = 6;

    public PokemonEditorAdvancedScreen(IndividualEditorBaseScreen previousScreen) {
        super(StringTextComponent.field_240750_d_);
        this.previousScreen = previousScreen;
        this.data = this.previousScreen.p;
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        return this.func_241217_q_() != null && this.func_241217_q_().func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    @Override
    public void func_231160_c_() {
        if (this.abilityDropDown != null) {
            this.checkFields();
        }
        super.func_231160_c_();
        this.field_230710_m_.add(new IndexedButton(1, this.field_230708_k_ / 2 + 155, this.field_230709_l_ / 2 + 90, 30, 20, (ITextComponent)new TranslationTextComponent("gui.guiItemDrops.ok"), this::actionPerformed));
        Ability[] allAbilities = this.data.getForm().getAbilities().getAll();
        List<String> abilityList = Arrays.stream(allAbilities).filter(Objects::nonNull).map(Ability::getName).collect(Collectors.toList());
        int abilityWidth = this.getLongestString(abilityList);
        this.abilityDropDown = new DropDown<String>(abilityList, this.data.getAbilityName(), this.field_230708_k_ / 2 - 130, this.field_230709_l_ / 2 - 40, 80, 50, Math.max(80, abilityWidth)).setGetOptionString(ability -> I18n.func_135052_a((String)("ability." + ability + ""), (Object[])new Object[0]));
        this.addDropDown(this.abilityDropDown);
        this.field_230710_m_.add(new IndexedButton(3, this.field_230708_k_ / 2 + 125, this.field_230709_l_ / 2 - 50, 60, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.maxivs"), this::actionPerformed));
        this.field_230710_m_.add(new IndexedButton(4, this.field_230708_k_ / 2 + 125, this.field_230709_l_ / 2 - 25, 60, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.minivs"), this::actionPerformed));
        this.field_230710_m_.add(new IndexedButton(5, this.field_230708_k_ / 2 + 125, this.field_230709_l_ / 2, 60, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.randomivs"), this::actionPerformed));
        this.field_230710_m_.add(new IndexedButton(6, this.field_230708_k_ / 2 + 125, this.field_230709_l_ / 2 + 35, 60, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.resetevs"), this::actionPerformed));
        this.allText = new TextFieldWidget[15];
        for (int i = 0; i < this.stats.length; ++i) {
            this.evText[i] = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 + 45, this.field_230709_l_ / 2 - 55 + i * 25, 30, 20, StringTextComponent.field_240750_d_);
            this.evText[i].func_146180_a(String.valueOf(this.data.getEVs().getArray()[i]));
            this.ivText[i] = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 + 85, this.field_230709_l_ / 2 - 55 + i * 25, 30, 20, StringTextComponent.field_240750_d_);
            this.ivText[i].func_146180_a(String.valueOf(this.data.getIVs().getArray()[i]));
            this.field_230705_e_.add(this.evText[i]);
            this.field_230705_e_.add(this.ivText[i]);
            this.allText[i] = this.evText[i];
            this.allText[i + this.evText.length] = this.ivText[i];
        }
        this.heldText = new TabCompleteTextField(13, this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 130, this.field_230709_l_ / 2 - 4, 80, 20).setCompletions(ItemRegistration.getAllItems().stream().filter(item -> item instanceof HeldItem).map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toSet()));
        this.field_230705_e_.add(this.heldText);
        if (!this.data.getHeldItem().func_190926_b()) {
            this.heldText.func_146180_a(this.data.getHeldItem().func_77973_b().getRegistryName().toString());
            this.updateHeldItem();
        }
        this.natureText = new TabCompleteTextField(14, this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 130, this.field_230709_l_ / 2 + 34, 80, 20).setCompletions(Arrays.stream(Nature.values()).map(ITranslatable::getLocalizedName).collect(Collectors.toSet()));
        this.natureText.func_146180_a(this.data.getBaseNature().getLocalizedName());
        this.field_230705_e_.add(this.natureText);
        this.friendshipText = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 130, this.field_230709_l_ / 2 + 70, 80, 20, StringTextComponent.field_240750_d_);
        this.friendshipText.func_146180_a(String.valueOf(this.data.getFriendship()));
        this.field_230705_e_.add(this.friendshipText);
        this.field_230705_e_.addAll(this.field_230710_m_);
        this.allText[12] = this.heldText;
        this.allText[13] = this.natureText;
        this.allText[14] = this.friendshipText;
    }

    private int getLongestString(List<String> items) {
        return ScreenHelper.getLongestStringWidth(items.stream().map(s -> I18n.func_135052_a((String)("ability." + s + ""), (Object[])new Object[0])).collect(Collectors.toList())) + 2;
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.field_230708_k_ / 2.0f - 200.0f, (float)this.field_230709_l_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        ScreenHelper.drawCenteredString(matrix, this.previousScreen.titleText, (float)this.field_230708_k_ / 2.0f, (float)this.field_230709_l_ / 2.0f - 90.0f, 0, false);
        for (int i = 0; i < this.stats.length; ++i) {
            ScreenHelper.drawStringRightAligned(matrix, this.stats[i].getLocalizedName(), (float)this.field_230708_k_ / 2.0f + 40.0f, (float)this.field_230709_l_ / 2.0f - 50.0f + (float)(i * 25), 0, false);
        }
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.evs", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f + 50.0f, (float)this.field_230709_l_ / 2.0f - 70.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.ivs", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f + 90.0f, (float)this.field_230709_l_ / 2.0f - 70.0f, 0);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.screenpokechecker.ability", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 90.0f, (float)(this.abilityDropDown.getTop() - 10), 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.helditem", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 90.0f, (float)(this.heldText.field_230691_m_ - 10), 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.screenpokechecker.nature", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 90.0f, (float)(this.natureText.field_230691_m_ - 10), 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.screenpokechecker.happiness", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 90.0f, (float)(this.friendshipText.field_230691_m_ - 10), 0, false);
        if (!this.heldItem.func_190926_b()) {
            this.field_230707_j_.func_180450_b(this.heldItem, this.field_230708_k_ / 2 - 150, this.heldText.field_230691_m_);
        }
        ScreenHelper.drawImageQuad(this.data.getSprite(), matrix, (float)this.field_230708_k_ / 2.0f - 157.0f, (float)this.field_230709_l_ / 2.0f - 73.0f, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_231042_a_(char key, int keyCode) {
        if (this.heldText.func_230999_j_()) {
            this.updateHeldItem();
        }
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        return super.func_231042_a_(key, keyCode);
    }

    @Override
    public boolean mouseClickedUnderMenus(double mouseX, double mouseY, int clickedButton) {
        for (TextFieldWidget textField : this.allText) {
            textField.func_231044_a_(mouseX, mouseY, clickedButton);
        }
        return super.mouseClickedUnderMenus(mouseX, mouseY, clickedButton);
    }

    protected void actionPerformed(Button button) {
        block4: {
            int id;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            if (!(button instanceof IndexedButton)) break block4;
                            id = ((IndexedButton)button).id;
                            if (id != 1) break block5;
                            this.saveFields();
                            Minecraft.func_71410_x().func_147108_a((Screen)this.previousScreen);
                            break block4;
                        }
                        if (id != 3) break block6;
                        for (TextFieldWidget iv : this.ivText) {
                            iv.func_146180_a("31");
                        }
                        break block4;
                    }
                    if (id != 4) break block7;
                    for (TextFieldWidget iv : this.ivText) {
                        iv.func_146180_a("0");
                    }
                    break block4;
                }
                if (id != 5) break block8;
                for (TextFieldWidget iv : this.ivText) {
                    iv.func_146180_a(String.valueOf(RandomHelper.getRandomNumberBetween(0, 31)));
                }
                break block4;
            }
            if (id != 6) break block4;
            for (TextFieldWidget ev : this.evText) {
                ev.func_146180_a("0");
            }
        }
    }

    private void saveFields() {
        if (this.checkFields()) {
            this.field_230706_i_.func_147108_a((Screen)this.previousScreen);
        }
    }

    private void updateHeldItem() {
        try {
            Item newItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(this.heldText.func_146179_b()));
            if (newItem instanceof HeldItem) {
                this.heldItem = new ItemStack((IItemProvider)newItem);
            } else if (!"en_us".equals(Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode())) {
                for (Item item : ItemRegistration.getAllItems()) {
                    if (!(item instanceof HeldItem) || !new ItemStack((IItemProvider)item).func_200301_q().getString().equalsIgnoreCase(this.heldText.func_146179_b())) continue;
                    this.heldItem = new ItemStack((IItemProvider)item);
                    return;
                }
                this.heldItem = ItemStack.field_190927_a;
            } else {
                this.heldItem = ItemStack.field_190927_a;
            }
        }
        catch (Exception e) {
            Pixelmon.LOGGER.warn("Failed to update held item!");
            e.printStackTrace();
        }
    }

    private boolean checkFields() {
        boolean isValid = true;
        for (TextFieldWidget iv : this.ivText) {
            try {
                int ivNumber = Integer.parseInt(iv.func_146179_b());
                if (ivNumber < 0) {
                    isValid = false;
                    iv.func_146180_a("0");
                    continue;
                }
                if (ivNumber <= 31) continue;
                isValid = false;
                iv.func_146180_a("31");
            }
            catch (NumberFormatException e) {
                isValid = false;
                iv.func_146180_a("0");
            }
        }
        int evTotal = 0;
        for (TextFieldWidget ev : this.evText) {
            int evNumber;
            try {
                evNumber = Integer.parseInt(ev.func_146179_b());
                if (evNumber < 0) {
                    isValid = false;
                    ev.func_146180_a("0");
                    evNumber = 0;
                } else if (evNumber > 252) {
                    isValid = false;
                    ev.func_146180_a("252");
                    evNumber = 252;
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
                ev.func_146180_a("0");
                evNumber = 0;
            }
            if ((evTotal += evNumber) <= 510) continue;
            isValid = false;
            ev.func_146180_a(String.valueOf(evNumber - (evTotal - 510)));
            evTotal = 510;
        }
        Nature newNature = Nature.natureFromString(this.natureText.func_146179_b());
        if (newNature == null) {
            isValid = false;
            this.natureText.func_146180_a(this.data.getBaseNature().getLocalizedName());
        }
        this.updateHeldItem();
        if (this.heldItem.func_190926_b() && !this.heldText.func_146179_b().equals("")) {
            this.heldText.func_146180_a("");
            isValid = false;
        }
        int newFriendship = this.data.getFriendship();
        try {
            newFriendship = Integer.parseInt(this.friendshipText.func_146179_b());
            if (newFriendship > 255) {
                this.friendshipText.func_146180_a(String.valueOf(255));
                isValid = false;
            } else if (newFriendship < 0) {
                this.friendshipText.func_146180_a("0");
                isValid = false;
            }
        }
        catch (NumberFormatException iv) {
            // empty catch block
        }
        if (isValid) {
            try {
                for (int i = 0; i < this.stats.length; ++i) {
                    this.data.getEVs().setStat(this.stats[i], Integer.parseInt(this.evText[i].func_146179_b()));
                    this.data.getIVs().setStat(this.stats[i], Integer.parseInt(this.ivText[i].func_146179_b()));
                }
                this.data.setNature(newNature);
                this.data.setHeldItem(this.heldItem);
                this.data.setAbility(AbilityRegistry.getAbility(this.abilityDropDown.getSelected()));
                this.data.setFriendship(newFriendship);
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
        }
        return isValid;
    }
}

