/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;

public class PokeCheckerStatsScreen
extends PokeCheckerScreen {
    private static final int HEX_WHITE = 0xFFFFFF;
    private static final int HEX_DECREASE = 0xFF3030;
    private static final int HEX_INCREASE = 65280;

    PokeCheckerStatsScreen(PokeCheckerScreen tab) {
        super(tab);
    }

    public PokeCheckerStatsScreen(PokemonStorage storage, StoragePosition position, @Nullable Screen parent) {
        super(storage, position, parent);
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrix, int mouseX, int mouseY) {
        int hexColor = 0xFFFFFF;
        RenderSystem.normal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        if (!this.pokemon.isEgg()) {
            PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel()), (int)10, (int)-14, (int)hexColor);
            PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex()), (int)-30, (int)-14, (int)hexColor);
            if (this.pokemon.getOriginalTrainer() != null) {
                PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.pokemon.getOriginalTrainer(), (int)8, (int)126, (int)hexColor);
            }
        } else {
            PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???"), (int)10, (int)-14, (int)hexColor);
            PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???"), (int)-30, (int)-14, (int)hexColor);
            PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"???", (int)8, (int)126, (int)hexColor);
        }
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.ot", (Object[])new Object[0]), (int)-32, (int)111, (int)hexColor);
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"nbt.hp", (Object[])new Object[0]), (int)60, (int)-12, (int)hexColor);
        String strHP = String.valueOf(this.pokemon.getMaxHealth());
        if (this.pokemon.isEgg()) {
            strHP = "???";
        }
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)strHP, (int)(200 - strHP.length() * 3), (int)-12, (int)hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.ATTACK && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.ATTACK && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strATK = String.valueOf(this.pokemon.getStat(BattleStatsType.ATTACK));
        if (this.pokemon.isEgg()) {
            strATK = "???";
        }
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"nbt.attack", (Object[])new Object[0]), (int)60, (int)9, (int)hexColor);
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)strATK, (int)(200 - strATK.length() * 3), (int)9, (int)hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.DEFENSE && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.DEFENSE && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strDEF = String.valueOf(this.pokemon.getStat(BattleStatsType.DEFENSE));
        if (this.pokemon.isEgg()) {
            strDEF = "???";
        }
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"nbt.defense", (Object[])new Object[0]), (int)60, (int)28, (int)hexColor);
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)strDEF, (int)(200 - strDEF.length() * 3), (int)28, (int)hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.SPECIAL_ATTACK && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.SPECIAL_ATTACK && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strSATK = String.valueOf(this.pokemon.getStat(BattleStatsType.SPECIAL_ATTACK));
        if (this.pokemon.isEgg()) {
            strSATK = "???";
        }
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"nbt.spattack", (Object[])new Object[0]), (int)60, (int)48, (int)hexColor);
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)strSATK, (int)(200 - strSATK.length() * 3), (int)48, (int)hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.SPECIAL_DEFENSE && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.SPECIAL_DEFENSE && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strSDEF = String.valueOf(this.pokemon.getStat(BattleStatsType.SPECIAL_DEFENSE));
        if (this.pokemon.isEgg()) {
            strSDEF = "???";
        }
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"nbt.spdefense", (Object[])new Object[0]), (int)60, (int)69, (int)hexColor);
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)strSDEF, (int)(200 - strSDEF.length() * 3), (int)69, (int)hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.SPEED && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.SPEED && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strSPD = String.valueOf(this.pokemon.getStat(BattleStatsType.SPEED));
        if (this.pokemon.isEgg()) {
            strSPD = "???";
        }
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"nbt.speed", (Object[])new Object[0]), (int)60, (int)88, (int)hexColor);
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)strSPD, (int)(200 - strSPD.length() * 3), (int)88, (int)hexColor);
        hexColor = 0xFFFFFF;
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.happiness", (Object[])new Object[0]), (int)70, (int)113, (int)hexColor);
        PokeCheckerStatsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.nature", (Object[])new Object[0]), (int)157, (int)113, (int)hexColor);
        PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.growth", (Object[])new Object[0]), (int)8, (int)137, (int)hexColor);
        if (!this.pokemon.isEgg()) {
            boolean hasMintNature;
            PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)String.valueOf(this.pokemon.getFriendship()), (int)95, (int)132, (int)hexColor);
            Nature nature = this.pokemon.getBaseNature();
            Nature mintNature = this.pokemon.getMintNature();
            boolean bl = hasMintNature = mintNature != null && mintNature != nature;
            if (hasMintNature) {
                PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)mintNature.getLocalizedName(), (int)174, (int)145, (int)11927491);
            }
            PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)nature.getLocalizedName(), (int)174, (int)132, (int)-1);
            PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)this.pokemon.getGrowth().getTranslationKey(), (Object[])new Object[0]), (int)8, (int)150, (int)-1);
        } else {
            PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"???", (int)95, (int)132, (int)hexColor);
            PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"???", (int)174, (int)132, (int)-1);
            PokeCheckerStatsScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"???", (int)8, (int)150, (int)-1);
        }
        this.drawBasePokemonInfo(matrix);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summaryStats);
        this.func_238474_b_(matrix, (this.field_230708_k_ - this.xSize) / 2 - 40, (this.field_230709_l_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
    }

    @Override
    public void drawHealthBar(MatrixStack matrix, int x, int y, int width, int height, Pokemon pokemon) {
        RenderSystem.enableRescaleNormal();
        RenderSystem.disableColorMaterial();
        matrix.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        int barWidth = width - 6;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)(y + height), 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)y, 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        barWidth = !pokemon.isEgg() ? (int)((float)pokemon.getHealth() / (float)pokemon.getMaxHealth() * ((float)width - 6.0f)) : (int)((float)width - 6.0f);
        barWidth = (int)((float)pokemon.getHealth() / (float)pokemon.getMaxHealth() * ((float)width - 6.0f));
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)(y + height), 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)y, 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        matrix.func_227865_b_();
        RenderSystem.enableTexture();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableColorMaterial();
    }
}

