/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.NuggetCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerMovesScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerStatsScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerTMsScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerTabsScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerWarningLevelScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.RenamePokemonScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.ribbon.PokeCheckerRibbonsScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.awt.Color;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PokeCheckerScreen
extends Screen {
    private static final Color[] DYNAMAX_LEVELS = new Color[]{new Color(3601150), new Color(6941951), new Color(7984383), new Color(6142719), new Color(11375103), new Color(13274879), new Color(15948030), new Color(16662225), new Color(16721836), new Color(16654730)};
    protected int xSize = 176;
    protected int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    protected PokemonStorage storage;
    protected StoragePosition position;
    protected Pokemon pokemon;
    @Nullable
    protected Screen parent;
    private Button renameButton;

    public PokeCheckerScreen(PokemonStorage storage, StoragePosition position, @Nullable Screen parent) {
        super(StringTextComponent.field_240750_d_);
        this.storage = (PokemonStorage)Preconditions.checkNotNull((Object)storage);
        this.position = (StoragePosition)Preconditions.checkNotNull((Object)position);
        this.pokemon = (Pokemon)Preconditions.checkNotNull((Object)storage.get(position));
        this.parent = parent;
        this.renameButton = new IndexedButton(4, 0, 0, 50, 20, (ITextComponent)new TranslationTextComponent("gui.screenpokechecker.rename"), this::actionPerformed);
        this.renameButton.field_230694_p_ = false;
    }

    protected PokeCheckerScreen(PokeCheckerScreen tab) {
        this(tab.storage, tab.position, tab.parent);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(3, 0, this.field_230708_k_ / 2 + 107, this.field_230709_l_ / 2 + 80, 17, 15, "", this::actionPerformed));
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(0, 1, this.field_230708_k_ / 2 - 34 - 89 - 4, this.field_230709_l_ / 2 + 80, 89, 15, I18n.func_135052_a((String)"gui.screenpokechecker.summary", (Object[])new Object[0]), this::actionPerformed));
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(1, 2, this.field_230708_k_ / 2 - 34, this.field_230709_l_ / 2 + 80, 69, 15, I18n.func_135052_a((String)"gui.screenpokechecker.moves", (Object[])new Object[0]), this::actionPerformed));
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(2, 3, this.field_230708_k_ / 2 + 36, this.field_230709_l_ / 2 + 80, 69, 15, I18n.func_135052_a((String)"gui.screenpokechecker.stats", (Object[])new Object[0]), this::actionPerformed));
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(4, 5, this.field_230708_k_ / 2 - 44, this.field_230709_l_ / 2 - 107, 9, 9, "", this.pokemon, this::actionPerformed));
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(7, 6, this.field_230708_k_ / 2 - 44, this.field_230709_l_ / 2 - 1, 9, 8, "", this.pokemon, this::actionPerformed));
        this.func_230480_a_((Widget)this.renameButton);
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(8, 7, this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 - 80, 14, 14, "", this::actionPerformed));
        this.func_230480_a_((Widget)new PokeCheckerTabsScreen(9, 8, this.field_230708_k_ / 2 - 56, this.field_230709_l_ / 2 - 80, 16, 14, "", this::actionPerformed));
    }

    public void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).id) {
                case 0: {
                    this.func_231175_as__();
                    break;
                }
                case 1: {
                    this.field_230706_i_.func_147108_a((Screen)new PokeCheckerScreen(this));
                    break;
                }
                case 2: {
                    this.field_230706_i_.func_147108_a((Screen)new PokeCheckerMovesScreen(this));
                    break;
                }
                case 3: {
                    this.field_230706_i_.func_147108_a((Screen)new PokeCheckerStatsScreen(this));
                    break;
                }
                case 4: {
                    if (!PixelmonConfigProxy.getGeneral().isAllowPokemonNicknames() || this.pokemon.isEgg()) break;
                    this.field_230706_i_.func_147108_a((Screen)new RenamePokemonScreen(this));
                    break;
                }
                case 5: {
                    this.field_230706_i_.func_147108_a((Screen)new PokeCheckerWarningLevelScreen(this));
                    break;
                }
                case 6: {
                    if (!PixelmonConfigProxy.getGeneral().isAllowPokemonNicknames() || this.pokemon.isEgg()) break;
                    this.field_230706_i_.func_147108_a((Screen)new RenamePokemonScreen(this));
                    break;
                }
                case 7: {
                    this.field_230706_i_.func_147108_a((Screen)new PokeCheckerTMsScreen(this));
                    break;
                }
                case 8: {
                    this.field_230706_i_.func_147108_a((Screen)new PokeCheckerRibbonsScreen(this));
                }
            }
        }
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (keyCode == 256) {
            this.func_231175_as__();
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    public void func_231175_as__() {
        if (this.parent == null) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        } else {
            this.field_230706_i_.func_147108_a(this.parent);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseX > (double)((float)this.field_230708_k_ / 2.0f - 125.0f) && mouseX < (double)((float)this.field_230708_k_ / 2.0f - 40.0f) && mouseY > (double)((float)this.field_230709_l_ / 2.0f - 15.0f) && mouseY < (double)((float)this.field_230709_l_ / 2.0f + 5.0f)) {
            if (mouseButton == 1) {
                this.renameButton.field_230694_p_ = true;
                this.renameButton.field_230690_l_ = (int)mouseX;
                this.renameButton.field_230691_m_ = (int)mouseY;
            } else {
                this.renameButton.field_230694_p_ = false;
            }
        }
        this.arrowsMouseClicked(mouseX, mouseY);
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int i = this.guiLeft;
        int j = this.guiTop;
        this.drawGuiContainerBackgroundLayer(matrix, partialTicks, mouseX, mouseY);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        RenderHelper.func_227784_d_();
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)i, (double)j, 0.0);
        this.drawGuiContainerForegroundLayer(matrix, mouseX, mouseY);
        matrix.func_227865_b_();
    }

    public void drawGuiContainerForegroundLayer(MatrixStack matrix, int mouseX, int mouseY) {
        RenderSystem.normal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        if (!this.pokemon.isEgg()) {
            PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel()), (int)10, (int)-14, (int)0xFFFFFF);
            PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex()), (int)-30, (int)-14, (int)0xFFFFFF);
            if (this.pokemon.isFainted()) {
                PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.fainted", (Object[])new Object[0]), (int)117, (int)-13, (int)0xFFFFFF);
            } else {
                PokeCheckerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(this.pokemon.getHealth() + "/" + this.pokemon.getMaxHealth()), (int)140, (int)-14, (int)0xDDDDDD);
            }
        } else {
            PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???"), (int)10, (int)-14, (int)0xFFFFFF);
            PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???"), (int)-30, (int)-14, (int)0xFFFFFF);
            PokeCheckerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"???/???", (int)140, (int)-13, (int)0xDDDDDD);
        }
        PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.status", (Object[])new Object[0]), (int)-9, (int)111, (int)0xFFFFFF);
        PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.texp", (Object[])new Object[0]), (int)107, (int)32, (int)0xFFFFFF);
        PokeCheckerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.levelup", (Object[])new Object[0]), (int)134, (int)56, (int)0xFFFFFF);
        PokeCheckerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.dynamaxlevel", (Object[])new Object[0]), (int)134, (int)80, (int)0xFFFFFF);
        if (!this.pokemon.isEgg()) {
            String xp = String.valueOf(this.pokemon.getExperience());
            String xptl = String.valueOf(this.pokemon.getExperienceToLevelUp());
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, xp, 135.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(xp) / 2.0f, 44.0f, 0xFFFFFF);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, xptl, 135.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(xptl) / 2.0f, 68.0f, 0xFFFFFF);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            for (int i = 0; i < 10; ++i) {
                float[] rgb;
                if (this.pokemon.getDynamaxLevel() > i) {
                    Color c = DYNAMAX_LEVELS[i];
                    rgb = new float[]{(float)c.getRed() / 256.0f, (float)c.getGreen() / 256.0f, (float)c.getBlue() / 256.0f};
                } else {
                    rgb = new float[]{0.5f, 0.5f, 0.5f};
                }
                ScreenHelper.drawImageQuad(Resources.parallelogram, matrix, 82 + i * 10, 91.0f, 13.0f, 13.0f, 0.0f, 0.0f, 1.0f, 1.0f, rgb[0], rgb[1], rgb[2], 1.0f, 0.0f);
            }
            RenderSystem.disableBlend();
        } else {
            PokeCheckerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"???", (int)135, (int)44, (int)0xFFFFFF);
            PokeCheckerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"???", (int)135, (int)68, (int)0xFFFFFF);
        }
        PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.ability", (Object[])new Object[0]), (int)75, (int)116, (int)0xFFFFFF);
        if (!this.pokemon.isEgg()) {
            try {
                PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)("ability." + this.pokemon.getAbility().getName() + ""), (Object[])new Object[0]), (int)130, (int)116, (int)0xFFFFFF);
                ScreenHelper.drawSplitString(matrix, I18n.func_135052_a((String)("ability." + this.pokemon.getAbility().getName() + ".description"), (Object[])new Object[0]), 62, 131, 145, 0xFFFFFF);
            }
            catch (Exception e) {
                PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"ability.ComingSoon", (Object[])new Object[0]), (int)130, (int)117, (int)0xFFFFFF);
                ScreenHelper.drawSplitString(matrix, I18n.func_135052_a((String)"ability.ComingSoon.description", (Object[])new Object[0]), 62, 131, 145, 0xFFFFFF);
            }
        } else {
            PokeCheckerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"ability.Egg", (Object[])new Object[0]), (int)130, (int)116, (int)0xFFFFFF);
            ScreenHelper.drawSplitString(matrix, I18n.func_135052_a((String)this.pokemon.getEggDescription(), (Object[])new Object[0]), 62, 131, 145, 0xFFFFFF);
        }
        this.drawBasePokemonInfo(matrix);
    }

    protected void drawBasePokemonInfo(MatrixStack matrix) {
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), matrix, -27.0f, 14.0f, 68.0f, 68.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (!this.pokemon.isEgg()) {
            Element type1 = this.pokemon.getForm().getTypes().get(0);
            Element type2 = this.pokemon.getForm().getTypes().size() > 1 ? this.pokemon.getForm().getTypes().get(1) : null;
            float x = type1.textureX;
            float y = type1.textureY;
            float x1 = 0.0f;
            float y1 = 0.0f;
            if (type2 != null) {
                x1 = type2.textureX;
                y1 = type2.textureY;
            }
            if (type2 != Element.MYSTERY && type2 != null) {
                ScreenHelper.drawImageQuadUV(Resources.types, matrix, 8.0f, 0.0f, 21.0f, 21.0f, x1, y1, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                ScreenHelper.drawImageQuadUV(Resources.types, matrix, -14.0f, 0.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else {
                ScreenHelper.drawImageQuadUV(Resources.types, matrix, -2.0f, 0.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            this.pokemon.getExtraStats(MeltanStats.class).ifPresent(stats -> this.pokemon.getForm().getFirstEvolutionConditionOfType(NuggetCondition.class).ifPresent(condition -> {
                ScreenHelper.drawItem(matrix, new ItemStack((IItemProvider)Items.field_191525_da), -33.0f, 16.0f, 770, 771);
                ScreenHelper.drawCenteredString(matrix, String.valueOf(stats.nuggetsFed), -24.5f, 31.0f, stats.nuggetsFed >= condition.nuggets ? 65280 : 0xFFFFFF, true);
            }));
        }
        if (this.pokemon.isShiny()) {
            ScreenHelper.drawImageQuad(Resources.shiny, matrix, -35.0f, 73.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (this.pokemon.getPokerus() != null && !Objects.equals((Object)this.pokemon.getPokerus().type, (Object)PokerusStrain.UNINFECTED)) {
            ScreenHelper.drawImageQuad(this.pokemon.getPokerus().canInfect() ? Resources.pokerusInfectious : Resources.pokerusCured, matrix, 40.0f, 72.0f, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderSystem.disableBlend();
    }

    public void drawGuiContainerBackgroundLayer(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summarySummary);
        this.func_238474_b_(matrix, (this.field_230708_k_ - this.xSize) / 2 - 40, (this.field_230709_l_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        this.drawHealthBar(matrix, (this.field_230708_k_ - this.xSize) / 2 + 59, (this.field_230709_l_ - this.ySize) / 2 - 18, 154, 14, this.pokemon);
        this.func_238474_b_(matrix, (this.field_230708_k_ - this.xSize) / 2 + 59, (this.field_230709_l_ - this.ySize) / 2 - 18, 103, 222, 150, 16);
        this.drawExpBar(matrix, (this.field_230708_k_ - this.xSize) / 2 + 86, (this.field_230709_l_ - this.ySize) / 2, 122, 14, this.pokemon);
        this.func_238474_b_(matrix, (this.field_230708_k_ - this.xSize) / 2 + 59, (this.field_230709_l_ - this.ySize) / 2, 104, 239, 150, 16);
        float[] texturePair = StatusType.getTexturePos(this.pokemon.getStatus().type);
        float textureX1 = texturePair[0];
        float textureY1 = texturePair[1];
        if (textureX1 != -1.0f) {
            ScreenHelper.bindTexture(Resources.status);
            ScreenHelper.simpleDrawImageQuad(matrix, (float)(this.field_230708_k_ - this.xSize) / 2.0f - 6.0f, (float)(this.field_230709_l_ - this.ySize) / 2.0f + 130.0f, 24.0f, 24.0f, textureX1 / 768.0f, textureY1 / 768.0f, (textureX1 + 240.0f) / 768.0f, (textureY1 + 240.0f) / 768.0f, 0.0f);
        } else {
            ScreenHelper.bindTexture(Resources.status);
            ScreenHelper.simpleDrawImageQuad(matrix, (float)(this.field_230708_k_ - this.xSize) / 2.0f - 6.0f, (float)(this.field_230709_l_ - this.ySize) / 2.0f + 130.0f, 24.0f, 24.0f, 0.34375f, 0.34375f, 0.65625f, 0.65625f, 0.0f);
        }
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected void drawPokemonName(MatrixStack matrix) {
        if (this.pokemon.isEgg()) {
            this.drawCenteredStringWithoutShadow(matrix, "Egg", (this.field_230708_k_ - this.xSize) / 2 + 7, (this.field_230709_l_ - this.ySize) / 2 + 89, 0xFFFFFF);
        } else {
            int offset;
            int textSize = 0;
            int n = offset = this.pokemon.hasGigantamaxFactor() ? 9 : 0;
            if (this.pokemon.getFormattedNickname() != null) {
                String ogName = "(" + this.pokemon.getSpecies().getLocalizedName() + ")";
                this.drawCenteredStringWithoutShadow(matrix, ogName, (this.field_230708_k_ - this.xSize) / 2 + 7 + offset, (this.field_230709_l_ - this.ySize) / 2 + 93, 0xFFFFFF);
                this.drawCenteredStringWithoutShadow(matrix, this.pokemon.getFormattedNickname(), (this.field_230708_k_ - this.xSize) / 2 + 7 + offset, (this.field_230709_l_ - this.ySize) / 2 + 84, 0xFFFFFF);
                textSize = Math.max(this.field_230712_o_.func_238414_a_((ITextProperties)this.pokemon.getFormattedNickname()), this.field_230712_o_.func_78256_a(ogName));
            } else {
                this.drawCenteredStringWithoutShadow(matrix, this.pokemon.getFormattedDisplayName(), (this.field_230708_k_ - this.xSize) / 2 + 7 + offset, (this.field_230709_l_ - this.ySize) / 2 + 89, 0xFFFFFF);
                textSize = this.field_230712_o_.func_238414_a_((ITextProperties)this.pokemon.getFormattedDisplayName());
            }
            if (this.pokemon.hasGigantamaxFactor()) {
                RenderSystem.enableAlphaTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                ScreenHelper.drawImageQuad(Resources.gmaxFactor, matrix, (float)(this.field_230708_k_ - this.xSize) / 2.0f - (float)textSize / 2.0f - 3.0f, (float)(this.field_230709_l_ - this.ySize) / 2.0f + 84.0f, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    public void arrowsMouseClicked(double mouseX, double mouseY) {
        int l1 = (this.field_230708_k_ - this.xSize) / 2 + 220;
        int l2 = (this.field_230708_k_ - this.xSize) / 2 - 62;
        int w = 16;
        int t = (this.field_230709_l_ - this.ySize) / 2;
        int h = 21;
        if (mouseY > (double)t && mouseY < (double)(t + h)) {
            if (mouseX > (double)l1 && mouseX < (double)(l1 + w)) {
                SoundHelper.playButtonPressSound();
                this.setNextPokemon();
            }
            if (mouseX > (double)l2 && mouseX < (double)(l2 + w)) {
                SoundHelper.playButtonPressSound();
                this.setPrevPokemon();
            }
        }
    }

    private void setPrevPokemon() {
        Tuple<Pokemon, StoragePosition> previous = ClientStorageManager.getPrevious(this.storage, this.position);
        if (previous != null && previous.func_76341_a() != null) {
            this.pokemon = (Pokemon)previous.func_76341_a();
            this.position = (StoragePosition)previous.func_76340_b();
        }
    }

    private void setNextPokemon() {
        Tuple<Pokemon, StoragePosition> previous = ClientStorageManager.getNext(this.storage, this.position);
        if (previous != null && previous.func_76341_a() != null) {
            this.pokemon = (Pokemon)previous.func_76341_a();
            this.position = (StoragePosition)previous.func_76340_b();
        }
    }

    public void drawArrows(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.position.box != -1) {
            return;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summaryMoves);
        int l1 = (this.field_230708_k_ - this.xSize) / 2 + 220;
        int l2 = (this.field_230708_k_ - this.xSize) / 2 - 62;
        int w = 16;
        int t = (this.field_230709_l_ - this.ySize) / 2;
        int h = 21;
        this.func_238474_b_(matrix, l1, t, 24, 207, w, h);
        this.func_238474_b_(matrix, l2, t, 42, 207, w, h);
        if (mouseY > t && mouseY < t + h) {
            if (mouseX > l1 && mouseX < l1 + w) {
                this.func_238474_b_(matrix, l1, t, 60, 207, w, h);
            }
            if (mouseX > l2 && mouseX < l2 + w) {
                this.func_238474_b_(matrix, l2, t, 78, 207, w, h);
            }
        }
    }

    private void drawExpBar(MatrixStack matrix, int x, int y, int width, int height, Pokemon pokemon) {
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        matrix.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        int barWidth = !pokemon.isEgg() ? (int)(pokemon.getExperienceFraction() * ((float)width - 6.0f)) : (int)(0.0f * ((float)width - 6.0f));
        if (pokemon.getPokemonLevel() == PixelmonServerConfig.maxLevel) {
            barWidth = 0;
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_227885_a_(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, 0.0).func_227885_a_(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)(y + height), 0.0).func_227885_a_(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)y, 0.0).func_227885_a_(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        matrix.func_227865_b_();
        RenderSystem.enableTexture();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableColorMaterial();
    }

    public void drawHealthBar(MatrixStack matrix, int x, int y, int width, int height, Pokemon pokemon) {
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        matrix.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        int barWidth = width - 6;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)(y + height), 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)y, 0.0).func_227885_a_(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        float healthFraction = pokemon.isEgg() ? 1.0f : (float)pokemon.getHealth() / (float)pokemon.getMaxHealth();
        barWidth = (int)(healthFraction * ((float)width - 24.0f)) + 18;
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)(y + height), 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)y, 0.0).func_227885_a_(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        matrix.func_227865_b_();
        RenderSystem.enableTexture();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableColorMaterial();
    }

    public void drawCenteredStringWithoutShadow(MatrixStack matrix, String text, int x, int y, int color) {
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)x - (float)this.field_230706_i_.field_71466_p.func_78256_a(text) / 2.0f, (float)y, color);
    }

    public void drawCenteredStringWithoutShadow(MatrixStack matrix, ITextComponent text, int x, int y, int color) {
        this.field_230706_i_.field_71466_p.func_243248_b(matrix, text, (float)x - (float)this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)text) / 2.0f, (float)y, color);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

