/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.override;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.client.gui.override.ScreenModifier;
import com.pixelmonmod.pixelmon.client.gui.override.escape.cosmetic.EscapeMenuCosmeticModifier;
import com.pixelmonmod.pixelmon.client.gui.override.load.ServerConnectModifier;
import com.pixelmonmod.pixelmon.client.gui.override.load.WorldLoadModifier;
import com.pixelmonmod.pixelmon.client.gui.override.main.MainMenuModifier;
import com.pixelmonmod.pixelmon.client.gui.override.multiplayer.MultiplayerScreenModifier;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MenuOverrideFactory {
    private static Map<Class<? extends Screen>, List<ScreenModifier>> REGISTERED_MODIFIERS = Maps.newConcurrentMap();

    private static void registerModifier(ScreenModifier modifier) {
        REGISTERED_MODIFIERS.computeIfAbsent(modifier.getScreenClass(), ___ -> Lists.newArrayList()).add(modifier);
    }

    @SubscribeEvent
    public static void onGuiOpen(GuiScreenEvent.InitGuiEvent.Post event) {
        List<ScreenModifier> screenModifiers = REGISTERED_MODIFIERS.get(event.getGui().getClass());
        if (screenModifiers == null) {
            return;
        }
        for (ScreenModifier screenModifier : screenModifiers) {
            screenModifier.onPreRender(event);
        }
    }

    @SubscribeEvent
    public static void onBackgroundDraw(GuiScreenEvent.BackgroundDrawnEvent event) {
        List<ScreenModifier> screenModifiers = REGISTERED_MODIFIERS.get(event.getGui().getClass());
        if (screenModifiers == null) {
            return;
        }
        for (ScreenModifier screenModifier : screenModifiers) {
            screenModifier.onBackgroundDraw(event);
        }
    }

    static {
        MenuOverrideFactory.registerModifier(new EscapeMenuCosmeticModifier());
        MenuOverrideFactory.registerModifier(new WorldLoadModifier());
        MenuOverrideFactory.registerModifier(new ServerConnectModifier());
        MenuOverrideFactory.registerModifier(new MainMenuModifier());
        MenuOverrideFactory.registerModifier(new MultiplayerScreenModifier());
    }
}

