/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class QuestGiverNPCEditorScreen
extends DropDownScreen {
    public static int currentNPCID;
    public static ArrayList<String> chatPages;
    public static boolean chatChanged;
    public static String name;
    NPCQuestGiver npc;
    TextFieldWidget nameBox;
    TextFieldWidget page1Box;
    TextFieldWidget page2Box;
    TextFieldWidget page3Box;
    TextFieldWidget page4Box;
    TextFieldWidget textureBox;
    public static List<ClientNPCData> npcData;
    String oldName;

    public QuestGiverNPCEditorScreen(int npcID) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        Optional<NPCQuestGiver> npcOptional = NPCEntity.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, npcID, NPCQuestGiver.class);
        if (!npcOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.npc = npcOptional.get();
        currentNPCID = npcID;
        if (this.npc == null) {
            ScreenHelper.closeScreen();
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new IndexedButton(1, this.field_230708_k_ / 2 + 155, this.field_230709_l_ / 2 + 90, 30, 20, (ITextComponent)new TranslationTextComponent("gui.guiItemDrops.ok"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(6, this.field_230708_k_ / 2 + 70, this.field_230709_l_ / 2 + 90, 80, 20, (ITextComponent)new TranslationTextComponent("gui.npceditor.despawn"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(7, this.field_230708_k_ / 2 - 15, this.field_230709_l_ / 2 + 90, 80, 20, (ITextComponent)new TranslationTextComponent("gui.npceditor.copyuuid"), this::actionPerformed));
        this.nameBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 20, this.field_230709_l_ / 2 - 96, 180, 20, StringTextComponent.field_240750_d_);
        this.nameBox.func_146180_a(name);
        this.field_230705_e_.add(this.nameBox);
        this.textureBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 189, this.field_230709_l_ / 2 + 100, 149, 10, StringTextComponent.field_240750_d_);
        this.field_230705_e_.add(this.textureBox);
        String textureText = this.npc.getCustomSteveTexture();
        String type = this.npc.getBaseTrainer().textures.get(this.npc.getTextureIndex());
        if (type.startsWith("Custom")) {
            this.textureBox.func_146180_a(textureText.replaceAll(";.+", ""));
            textureText = type;
        }
        ArrayList npcs = Lists.newArrayList(npcData);
        npcs.add(new ClientNPCData("Custom_RP", "Custom_RP"));
        npcs.add(new ClientNPCData("Custom_PN", "Custom_PN"));
        npcs.sort(Comparator.comparing(ClientNPCData::getID));
        this.addDropDown(new DropDown<ClientNPCData>(npcs, new ClientNPCData(textureText), this.field_230708_k_ / 2 - 190, this.field_230709_l_ / 2 - 85, 140, 200).setGetOptionString(npc -> {
            if (npc.getTexture().contains(".png")) {
                return I18n.func_135052_a((String)("npc.model." + npc.getTexture().replace(".png", "")), (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)("trainer.model." + npc.getTexture()), (Object[])new Object[0]);
        }).setOnSelected(npc -> {
            if (npc.getID().startsWith("Custom")) {
                NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, EnumNPCServerPacketType.TextureIndex, this.npc.getBaseTrainer().textures.indexOf(npc.getID())));
                this.textureBox.func_146180_a("");
            } else {
                NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, (ClientNPCData)npc));
            }
        }).setInactiveTop(this.field_230709_l_ / 2 + 85).setOrdered());
        this.page1Box = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 - 50, 260, 20, StringTextComponent.field_240750_d_);
        this.page1Box.func_146203_f(128);
        if (!chatPages.isEmpty()) {
            this.page1Box.func_146180_a(chatPages.get(0));
        }
        this.field_230705_e_.add(this.page1Box);
        this.page2Box = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 - 15, 260, 20, StringTextComponent.field_240750_d_);
        this.page2Box.func_146203_f(128);
        if (chatPages.size() > 1) {
            this.page2Box.func_146180_a(chatPages.get(1));
        }
        this.field_230705_e_.add(this.page2Box);
        this.page3Box = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 + 20, 260, 20, StringTextComponent.field_240750_d_);
        this.page3Box.func_146203_f(128);
        if (chatPages.size() > 2) {
            this.page3Box.func_146180_a(chatPages.get(2));
        }
        this.field_230705_e_.add(this.page3Box);
        this.page4Box = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 + 55, 260, 20, StringTextComponent.field_240750_d_);
        this.page4Box.func_146203_f(128);
        if (chatPages.size() > 3) {
            this.page4Box.func_146180_a(chatPages.get(3));
        }
        this.field_230705_e_.add(this.page4Box);
        chatChanged = false;
        this.oldName = name;
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (!this.oldName.equals(name)) {
            this.oldName = name;
            this.nameBox.func_146180_a(name);
        }
        if (chatChanged) {
            chatChanged = false;
            if (!chatPages.isEmpty()) {
                this.page1Box.func_146180_a(chatPages.get(0));
            }
            if (chatPages.size() > 1) {
                this.page2Box.func_146180_a(chatPages.get(1));
            }
            if (chatPages.size() > 2) {
                this.page3Box.func_146180_a(chatPages.get(2));
            }
            if (chatPages.size() > 3) {
                this.page4Box.func_146180_a(chatPages.get(3));
            }
        }
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.field_230708_k_ / 2.0f - 200.0f, (float)this.field_230709_l_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        ScreenHelper.drawEntity(matrix, (LivingEntity)this.npc, this.field_230708_k_ / 2 - 140, this.field_230709_l_ / 2 + 50, 60.0f, 0.0f, 0.0f);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 60.0f, (float)this.field_230709_l_ / 2.0f - 90.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.npceditor.page1", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 80.0f, (float)this.field_230709_l_ / 2.0f - 61.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.npceditor.page2", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 80.0f, (float)this.field_230709_l_ / 2.0f - 26.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.npceditor.page3", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 80.0f, (float)this.field_230709_l_ / 2.0f + 9.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.npceditor.page4", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 80.0f, (float)this.field_230709_l_ / 2.0f + 44.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.model", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 180.0f, (float)this.field_230709_l_ / 2.0f + 72.0f, 0);
        this.nameBox.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        this.page1Box.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        this.page2Box.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        this.page3Box.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        this.page4Box.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        if (this.isCustomTexture()) {
            this.textureBox.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231042_a_(char key, int par2) {
        this.nameBox.func_231042_a_(key, par2);
        this.page1Box.func_231042_a_(key, par2);
        this.page2Box.func_231042_a_(key, par2);
        this.page3Box.func_231042_a_(key, par2);
        this.page4Box.func_231042_a_(key, par2);
        if (this.isCustomTexture()) {
            this.textureBox.func_231042_a_(key, par2);
        }
        ScreenHelper.switchFocus(par2, this.nameBox, this.page1Box, this.page2Box, this.page3Box, this.page4Box, this.textureBox);
        if (par2 == 256 || par2 == 257) {
            this.saveFields();
        }
        return false;
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int button) {
        this.nameBox.func_231044_a_(x, y, button);
        this.page1Box.func_231044_a_(x, y, button);
        this.page2Box.func_231044_a_(x, y, button);
        this.page3Box.func_231044_a_(x, y, button);
        this.page4Box.func_231044_a_(x, y, button);
        this.textureBox.func_231044_a_(x, y, button);
        return false;
    }

    protected void actionPerformed(Button button) {
        if (button.field_230693_o_ && button instanceof IndexedButton) {
            switch (((IndexedButton)button).id) {
                case 1: {
                    this.saveFields();
                    break;
                }
                case 6: {
                    NetworkHelper.sendToServer(new DeleteTrainerPacket(currentNPCID));
                    ScreenHelper.closeScreen();
                    break;
                }
                case 7: {
                    Minecraft.func_71410_x().field_195559_v.func_197960_a(this.npc.func_110124_au().toString());
                }
            }
        }
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    private void saveFields() {
        if (this.checkFields()) {
            ScreenHelper.closeScreen();
        }
    }

    private boolean checkFields() {
        if (this.nameBox.func_146179_b().equals("")) {
            return false;
        }
        if (currentNPCID <= 0) {
            currentNPCID = this.npc.getNPCID();
        }
        if (!this.nameBox.func_146179_b().equals(name)) {
            NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, EnumNPCServerPacketType.Name, this.nameBox.func_146179_b()));
        }
        ArrayList<String> pages = new ArrayList<String>();
        if (!this.page1Box.func_146179_b().equals("")) {
            pages.add(this.page1Box.func_146179_b());
        }
        if (!this.page2Box.func_146179_b().equals("")) {
            pages.add(this.page2Box.func_146179_b());
        }
        if (!this.page3Box.func_146179_b().equals("")) {
            pages.add(this.page3Box.func_146179_b());
        }
        if (!this.page4Box.func_146179_b().equals("")) {
            pages.add(this.page4Box.func_146179_b());
        }
        if (this.isCustomTexture()) {
            NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, EnumNPCServerPacketType.CustomSteveTexture, this.textureBox.func_146179_b()));
        }
        if (!this.compareChat(pages)) {
            NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, pages));
        }
        return true;
    }

    private boolean compareChat(ArrayList<String> pages) {
        if (pages.size() != chatPages.size()) {
            return false;
        }
        for (int i = 0; i < chatPages.size(); ++i) {
            String oldPage;
            String page = pages.get(i);
            if (page.equals(oldPage = chatPages.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isCustomTexture() {
        return this.npc.getBaseTrainer().textures.get(this.npc.getTextureIndex()).startsWith("Custom");
    }

    static {
        chatChanged = false;
        npcData = new ArrayList<ClientNPCData>();
    }
}

