/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.mail;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.mail.MailPacket;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MailScreen
extends Screen {
    private boolean editable = true;
    private ResourceLocation backgroundTexture;
    private final ResourceLocation sealButtonTexture = ResourceLocationHelper.of(Resources.prefix + "gui/mail/sealButton.png");
    private final ResourceLocation abandonButtonTexture = ResourceLocationHelper.of(Resources.prefix + "gui/mail/closeButton.png");
    private IndexedButton sealButton;
    private final int sealX = 60;
    private final int sealY = 185;
    private IndexedButton exitButton;
    private final int exitX = 100;
    private final int exitY = 185;
    private String bookContents = "";
    private String author = "";

    public MailScreen(ItemStack item) {
        super(StringTextComponent.field_240750_d_);
        String mailType = item.func_77977_a().split("_")[1];
        this.backgroundTexture = ResourceLocationHelper.of(Resources.prefix + "gui/mail/" + mailType + "mail.png");
        if (item.func_77942_o()) {
            CompoundNBT nbtdata = item.func_77978_p();
            this.editable = nbtdata.func_74767_n("editable");
            this.author = nbtdata.func_74779_i("author");
            this.bookContents = nbtdata.func_74779_i("contents");
        }
    }

    private void writeLetterData(boolean shouldSeal) {
        MailPacket packetMail = new MailPacket(shouldSeal, this.bookContents);
        NetworkHelper.sendToServer(packetMail);
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int buttonID = 0;
        int xOffset = (this.field_230708_k_ - 252) / 2;
        int yOffset = 2;
        int n = buttonID++;
        ((Object)((Object)this)).getClass();
        this.sealButton = new IndexedButton(n, xOffset + this.sealX, yOffset + 185, 30, 20, (ITextComponent)new TranslationTextComponent("gui.mail.seal"), this::actionPerformed);
        ((Object)((Object)this)).getClass();
        this.exitButton = new IndexedButton(buttonID, xOffset + this.exitX, yOffset + 185, 30, 20, (ITextComponent)new TranslationTextComponent("gui.mail.close"), this::actionPerformed);
        if (!this.editable) {
            this.sealButton.field_230693_o_ = false;
        }
        this.func_230480_a_((Widget)this.sealButton);
        this.func_230480_a_((Widget)this.exitButton);
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).id) {
                case 0: {
                    this.writeLetterData(true);
                    break;
                }
                case 1: {
                    if (this.editable) {
                        this.writeLetterData(false);
                        break;
                    }
                    Minecraft.func_71410_x().func_147108_a(null);
                }
            }
        }
    }

    public boolean func_231046_a_(int keyCode, int p_231046_2_, int p_231046_3_) {
        if (keyCode == 259) {
            if (!this.bookContents.isEmpty()) {
                this.bookContents = this.bookContents.substring(0, this.bookContents.length() - 1);
                return true;
            }
        } else if (keyCode == 257 || keyCode == 335) {
            String[] strings2 = this.bookContents.split("\n");
            if (strings2.length == 14) {
                return super.func_231046_a_(keyCode, p_231046_2_, p_231046_3_);
            }
            this.bookContents = this.bookContents + "\n";
            return true;
        }
        return super.func_231046_a_(keyCode, p_231046_2_, p_231046_3_);
    }

    public boolean func_231042_a_(char keyChar, int keyCode) {
        if (!this.editable) {
            return super.func_231042_a_(keyChar, keyCode);
        }
        switch (keyChar) {
            case '\u0016': {
                for (char character : this.getMinecraft().field_195559_v.func_197965_a().toCharArray()) {
                    this.addNormalCharacter(character);
                }
                break;
            }
            default: {
                this.addNormalCharacter(keyChar);
            }
        }
        return super.func_231042_a_(keyChar, keyCode);
    }

    private void addNormalCharacter(char keyChar) {
        int widthInPixels;
        if (!SharedConstants.func_71566_a((char)keyChar)) {
            return;
        }
        String[] strings = this.bookContents.split("\n");
        if (strings.length > 0 && (widthInPixels = this.field_230712_o_.func_78256_a(strings[strings.length - 1])) >= 200) {
            if (strings.length == 14) {
                return;
            }
            this.bookContents = this.bookContents + "\n";
        }
        this.bookContents = this.bookContents + keyChar;
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float wut) {
        int guiWidth = 252;
        int guiHeight = 188;
        this.field_230706_i_.func_110434_K().func_110577_a(this.backgroundTexture);
        int xOffset = (this.field_230708_k_ - 252) / 2;
        int yOffset = 2;
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)xOffset, (int)yOffset, (float)0.0f, (float)0.0f, (int)252, (int)188, (int)252, (int)188);
        int buttonWidth = 32;
        int buttonHeight = 32;
        if (this.editable) {
            this.field_230706_i_.func_110434_K().func_110577_a(this.sealButtonTexture);
            ((Object)((Object)this)).getClass();
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + this.sealX), (int)(yOffset + 185), (float)0.0f, (float)0.0f, (int)buttonWidth, (int)buttonHeight, (int)buttonWidth, (int)buttonHeight);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(this.abandonButtonTexture);
        ((Object)((Object)this)).getClass();
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + this.exitX), (int)(yOffset + 185), (float)0.0f, (float)0.0f, (int)buttonWidth, (int)buttonHeight, (int)buttonWidth, (int)buttonHeight);
        String[] lines = this.bookContents.split("\n");
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            String string = lines[lineNumber];
            float f = xOffset + 27;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrix, string, f, (float)(yOffset + 32 + lineNumber * 9 - 9), 0);
        }
        float f = xOffset + 164;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238421_b_(matrix, this.author, f, (float)(yOffset + 175 - 9), 0);
        this.drawButtonTooltips(matrix, mouseX, mouseY);
    }

    private void drawButtonTooltips(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.mouseOverButton(mouseX, mouseY, this.sealButton)) {
            ArrayList<TranslationTextComponent> tooltipData = new ArrayList<TranslationTextComponent>(1);
            tooltipData.add(new TranslationTextComponent("gui.mail.seal"));
            this.func_243308_b(matrix, tooltipData, mouseX, mouseY);
        } else if (this.mouseOverButton(mouseX, mouseY, this.exitButton)) {
            ArrayList<TranslationTextComponent> tooltipData = new ArrayList<TranslationTextComponent>(1);
            tooltipData.add(new TranslationTextComponent("gui.mail.close"));
            this.func_243308_b(matrix, tooltipData, mouseX, mouseY);
        }
    }

    private boolean mouseOverButton(int mouseX, int mouseY, Button button) {
        return button.field_230693_o_ && mouseX >= button.field_230690_l_ && mouseX <= button.field_230690_l_ + button.func_230998_h_() && mouseY >= button.field_230691_m_ && mouseY <= button.field_230691_m_ + button.func_230998_h_();
    }

    public boolean func_231177_au__() {
        return false;
    }
}

