/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.rules;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleTierRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.tiers.Tier;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.ClauseListScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportExportScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.DescriptiveText;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.OnOffButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TextAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class BattleRulesBaseScreen
extends DropDownScreen
implements IImportableContainer {
    protected BattleRules rules = new BattleRules();
    private String titleText;
    protected List<TextFieldWidget> textFields = new ArrayList<TextFieldWidget>();
    private TextFieldWidget levelCapField;
    private TextFieldWidget numPokemonField;
    private TextFieldWidget turnTimeField;
    private TextFieldWidget teamSelectTimeField;
    protected boolean editingEnabled = true;
    protected Button importExportButton;
    protected OnOffButton raiseToCapButton;
    protected Button battleTypeButton;
    protected OnOffButton fullHealButton;
    protected OnOffButton teamPreviewButton;
    protected Button[] editButtons;
    protected List<DescriptiveText> ruleLabels;
    protected List<BattleClause> selectedClauses = new ArrayList<BattleClause>();
    private ClauseListScreen allClauseList;
    private ClauseListScreen selectedClauseList;
    protected int centerX;
    protected int centerY;
    protected int rectBottom;
    protected int yChange;
    protected int clauseListHeight = 70;
    protected DropDown<Tier> tierMenu;

    public BattleRulesBaseScreen() {
        super((ITextComponent)new TranslationTextComponent("gui.battlerules.title"));
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.titleText = I18n.func_135052_a((String)"gui.battlerules.title", (Object[])new Object[0]);
    }

    @Override
    public void func_231160_c_() {
        if (!this.textFields.isEmpty()) {
            this.registerRules();
        }
        this.textFields.clear();
        super.func_231160_c_();
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2;
        this.rectBottom = this.centerY - 120 + this.getBackgroundHeight();
        int textHeight = 20;
        int leftFieldX = this.centerX - 130;
        int centerFieldX = this.centerX - 20;
        int rightFieldX = this.centerX + 120;
        int topY = this.centerY - 76 + this.yChange;
        int yOffset = 25;
        int centerY = topY + yOffset;
        int bottomY = topY + yOffset * 2;
        int numberFieldWidth = 30;
        this.levelCapField = this.createRuleField(leftFieldX, topY, numberFieldWidth, textHeight);
        this.numPokemonField = this.createRuleField(centerFieldX, centerY, numberFieldWidth, textHeight);
        this.turnTimeField = this.createRuleField(rightFieldX, topY, numberFieldWidth, textHeight);
        this.teamSelectTimeField = this.createRuleField(rightFieldX, centerY, numberFieldWidth, textHeight);
        this.textFields.addAll(Arrays.asList(this.levelCapField, this.numPokemonField, this.turnTimeField, this.teamSelectTimeField));
        this.field_230705_e_.addAll(this.textFields);
        int onOffButtonWidth = 30;
        int buttonHeight = 20;
        int leftButton = leftFieldX - 1;
        int id = 0;
        this.importExportButton = new IndexedButton(id++, this.centerX + 90, this.centerY - 120, 100, buttonHeight, (ITextComponent)new TranslationTextComponent("gui.pokemoneditor.importexport"), this::actionPerformed);
        this.raiseToCapButton = new OnOffButton(id++, leftButton, centerY, onOffButtonWidth, buttonHeight, this.rules.getOrDefault(BattleRuleRegistry.RAISE_TO_CAP), this::actionPerformed);
        this.func_230480_a_((Widget)this.raiseToCapButton);
        this.fullHealButton = new OnOffButton(id++, leftButton, bottomY, onOffButtonWidth, buttonHeight, this.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL), this::actionPerformed);
        this.func_230480_a_((Widget)this.fullHealButton);
        this.teamPreviewButton = new OnOffButton(id++, rightFieldX - 1, bottomY, onOffButtonWidth, buttonHeight, this.rules.getOrDefault(BattleRuleRegistry.TEAM_PREVIEW), this::actionPerformed);
        this.func_230480_a_((Widget)this.teamPreviewButton);
        this.battleTypeButton = new IndexedButton(id++, centerFieldX - 1, topY, 40, buttonHeight, (ITextComponent)new StringTextComponent(this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getLocalizedName()), this::actionPerformed);
        for (Button editButton : this.editButtons = new Button[]{this.importExportButton, this.battleTypeButton, this.raiseToCapButton, this.fullHealButton, this.teamPreviewButton}) {
            this.func_230480_a_((Widget)editButton);
        }
        this.ruleLabels = new ArrayList<DescriptiveText>();
        int textOffset = 5;
        int leftTextX = leftFieldX - textOffset;
        int centerTextX = centerFieldX - textOffset;
        int rightTextX = rightFieldX - textOffset;
        int topTextY = topY + textOffset;
        int centerTextY = topTextY + yOffset;
        int bottomTextY = topTextY + yOffset * 2;
        int tierTextX = this.centerX - 62;
        this.ruleLabels.add(this.createRuleLabel("levelcap", leftTextX, topTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("raisetocap", leftTextX, centerTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("fullheal", leftTextX, bottomTextY, TextAlignment.Right));
        this.ruleLabels.add(new DescriptiveText(I18n.func_135052_a((String)"gui.trainereditor.battletype", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.battlerules.description.battletype", (Object[])new Object[0]), centerTextX, topTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("numpokemon", centerTextX, centerTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("tier", tierTextX, bottomTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("turntime", rightTextX, topTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("teamselecttime", rightTextX, centerTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("teampreview", rightTextX, bottomTextY, TextAlignment.Right));
        int clauseListWidth = 120;
        int clauseListY = topTextY + yOffset * 2 + 30;
        int clauseListX = centerTextX - clauseListWidth / 2 + 10;
        this.allClauseList = new ClauseListScreen(this, BattleClauseRegistry.getClauseList(), clauseListY, clauseListX, clauseListWidth, this.clauseListHeight);
        this.selectedClauseList = new ClauseListScreen(this, this.selectedClauses, clauseListY, clauseListX + clauseListWidth + 10, clauseListWidth, this.clauseListHeight);
        this.func_230481_d_((IGuiEventListener)this.allClauseList);
        this.func_230481_d_((IGuiEventListener)this.selectedClauseList);
        ArrayList tiers = Lists.newArrayList(BattleTierRegistry.getAllTiers());
        this.tierMenu = new DropDown<Tier>(tiers, this.rules.getOrDefault(BattleRuleRegistry.TIER), tierTextX + 10, bottomTextY, 70, 100);
        this.addDropDown(this.tierMenu);
        this.setRules(this.rules);
    }

    private TextFieldWidget createRuleField(int x, int y, int width, int height) {
        return new TextFieldWidget(this.getMinecraft().field_71466_p, x, y, width, height, StringTextComponent.field_240750_d_);
    }

    private DescriptiveText createRuleLabel(String langKey, int x, int y, TextAlignment align) {
        return new DescriptiveText(I18n.func_135052_a((String)("gui.battlerules." + langKey), (Object[])new Object[0]), I18n.func_135052_a((String)("gui.battlerules.description." + langKey), (Object[])new Object[0]), x, y, align);
    }

    public void setRules(BattleRules rules) {
        this.rules = rules;
        this.setText(this.levelCapField, this.rules.getOrDefault(BattleRuleRegistry.LEVEL_CAP));
        this.setText(this.numPokemonField, this.rules.getOrDefault(BattleRuleRegistry.NUM_POKEMON));
        this.setBlankableText(this.turnTimeField, this.rules.getOrDefault(BattleRuleRegistry.TURN_TIME));
        this.setBlankableText(this.teamSelectTimeField, this.rules.getOrDefault(BattleRuleRegistry.TEAM_SELECT));
        this.raiseToCapButton.setOn(this.rules.getOrDefault(BattleRuleRegistry.RAISE_TO_CAP));
        this.fullHealButton.setOn(this.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL));
        this.teamPreviewButton.setOn(this.rules.getOrDefault(BattleRuleRegistry.TEAM_PREVIEW));
        this.battleTypeButton.func_238482_a_((ITextComponent)new StringTextComponent(this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getLocalizedName()));
        this.selectedClauses.clear();
        this.selectedClauses.addAll(this.rules.getClauseList());
        this.tierMenu.setSelected(this.rules.getOrDefault(BattleRuleRegistry.TIER));
    }

    private void setText(TextFieldWidget field, int number) {
        field.func_146180_a(Integer.toString(number));
    }

    private void setBlankableText(TextFieldWidget field, int number) {
        String fieldText = "";
        if (number > 0) {
            fieldText = Integer.toString(number);
        }
        field.func_146180_a(fieldText);
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        int textColor = 0;
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, this.centerX - 200, this.centerY - 120, 400.0f, this.getBackgroundHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        for (Button button : this.editButtons) {
            button.field_230693_o_ = this.editingEnabled;
        }
        this.importExportButton.field_230694_p_ = this.editingEnabled;
        ScreenHelper.drawCenteredString(matrix, this.titleText, (float)this.centerX, (float)(this.centerY - 90 + this.yChange), textColor);
        if (this.editingEnabled) {
            ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.battlerules.clauses", (Object[])new Object[0]), (float)this.allClauseList.getCenterX(), (float)(this.centerY + this.yChange), textColor);
        }
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.battlerules.selectedclauses", (Object[])new Object[0]), (float)this.selectedClauseList.getCenterX(), (float)(this.centerY + this.yChange), textColor);
        String description = "";
        for (DescriptiveText text : this.ruleLabels) {
            text.draw(matrix);
            if (!text.isHovering(mouseX, mouseY)) continue;
            description = text.getDescription();
        }
        ClauseListScreen[] renderLists = this.editingEnabled ? new ClauseListScreen[]{this.allClauseList, this.selectedClauseList} : new ClauseListScreen[]{this.selectedClauseList};
        for (ClauseListScreen list : renderLists) {
            int hoverIndex;
            if (!description.isEmpty() || (hoverIndex = list.getMouseOverIndex(mouseX, mouseY)) <= -1) continue;
            description = list.getElement(hoverIndex).getDescription();
        }
        if (!description.isEmpty()) {
            int descX = this.centerX - 190;
            int descY = this.centerY + 10 + this.yChange;
            int textWidth = 100;
            int boxOffset = 5;
            ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, descX - boxOffset, descY - boxOffset, textWidth + boxOffset * 2, 70.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.65f, 0.65f, 0.65f, 1.0f, 1.0f);
            String finalDescription = description;
            ScreenHelper.drawInUnicode(() -> ScreenHelper.drawSplitString(matrix, finalDescription, descX, descY, textWidth, textColor));
        }
    }

    protected int getBackgroundHeight() {
        return 240;
    }

    public boolean func_231042_a_(char key, int keyCode) {
        if (this.editingEnabled) {
            for (TextFieldWidget textField : this.textFields) {
                textField.func_231042_a_(key, keyCode);
            }
            ScreenHelper.switchFocus(keyCode, this.textFields);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        if (this.editingEnabled) {
            for (TextFieldWidget textField : this.textFields) {
                textField.func_231044_a_(x, y, mouseButton);
            }
            return true;
        }
        return false;
    }

    protected void actionPerformed(Button button) {
        if (button == this.importExportButton) {
            this.registerRules();
            this.field_230706_i_.func_147108_a((Screen)new ImportExportScreen(this, this.titleText));
        } else if (button == this.battleTypeButton) {
            this.rules.set(BattleRuleRegistry.BATTLE_TYPE, (Object)this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).next());
            this.battleTypeButton.func_238482_a_((ITextComponent)new StringTextComponent(this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getLocalizedName()));
        } else if (button instanceof OnOffButton) {
            ((OnOffButton)button).toggle();
        }
    }

    protected void registerRules() {
        this.rules.set(BattleRuleRegistry.LEVEL_CAP, this.levelCapField.func_146179_b()).set(BattleRuleRegistry.RAISE_TO_CAP, this.raiseToCapButton.isOn()).set(BattleRuleRegistry.NUM_POKEMON, this.numPokemonField.func_146179_b()).set(BattleRuleRegistry.TURN_TIME, this.turnTimeField.func_146179_b()).set(BattleRuleRegistry.TEAM_SELECT, this.teamSelectTimeField.func_146179_b()).set(BattleRuleRegistry.FULL_HEAL, this.fullHealButton.isOn()).set(BattleRuleRegistry.TEAM_PREVIEW, this.teamPreviewButton.isOn());
        this.rules.setNewClauses(this.selectedClauses);
        this.rules.set(BattleRuleRegistry.TIER, this.tierMenu.getSelected());
        this.setRules(this.rules);
    }

    private int parseBlankableText(String text) {
        if (text.trim().isEmpty()) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    @Override
    public String getExportText() {
        return this.rules.exportText();
    }

    @Override
    public String importText(String importText) {
        String result = this.rules.importText(importText);
        this.setRules(this.rules);
        return result;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    void clauseListSelected(List<BattleClause> clauses, int index) {
        if (!this.editingEnabled) {
            return;
        }
        BattleClause clause = clauses.get(index);
        if (this.selectedClauses.contains(clause)) {
            this.selectedClauses.remove(clause);
        } else {
            this.selectedClauses.add(clause);
            Collections.sort(this.selectedClauses);
        }
    }

    boolean isClauseSelected(List<BattleClause> clauses, int index) {
        if (clauses == this.selectedClauses) {
            return false;
        }
        return this.selectedClauses.contains(clauses.get(index));
    }

    protected void dimScreen(MatrixStack matrix) {
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(this.centerX - 200), (int)(this.centerY - 120), (int)(this.centerX + 200), (int)this.rectBottom, (int)0x5F000000);
    }

    protected void highlightButtons(MatrixStack matrix, int highlightOffsetX, int bottomOffset) {
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(this.centerX - highlightOffsetX), (int)(this.rectBottom - bottomOffset), (int)(this.centerX + highlightOffsetX), (int)(this.rectBottom - bottomOffset + 35), (int)-1);
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    protected boolean disableMenus() {
        return !this.editingEnabled;
    }
}

