/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonSpawnerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClientboundUpdateSpawnerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PixelmonSpawnerBlock
extends ContainerBlock {
    public PixelmonSpawnerBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 6000000.0f).func_226896_b_());
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PixelmonSpawnerTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!(player instanceof ServerPlayerEntity) || hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        if (!PixelmonSpawnerBlock.checkPermission(serverPlayer)) {
            return ActionResultType.SUCCESS;
        }
        PixelmonSpawnerTileEntity spawner = BlockHelper.getTileEntity(PixelmonSpawnerTileEntity.class, (IBlockReader)world, pos);
        serverPlayer.field_71135_a.func_147359_a((IPacket)spawner.func_189518_D_());
        NetworkHelper.sendPacket(serverPlayer, new ClientboundUpdateSpawnerPacket(new PixelmonSpawnerData(spawner.func_174877_v(), spawner.func_189517_E_(), spawner.pokemonList)));
        spawner.onActivate();
        OpenScreenPacket.open(player, EnumGuiScreen.PixelmonSpawner, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (world.func_201670_d()) {
            super.func_176208_a(world, pos, state, player);
            return;
        }
        PixelmonSpawnerTileEntity pixelmonSpawner = BlockHelper.getTileEntity(PixelmonSpawnerTileEntity.class, (IBlockReader)world, pos);
        if (pixelmonSpawner != null) {
            pixelmonSpawner.despawnAllPokemon();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        boolean bl = flag = world.func_175640_z(pos) || world.func_175640_z(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
        if (flag) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        PixelmonSpawnerTileEntity spawner = BlockHelper.getTileEntity(PixelmonSpawnerTileEntity.class, (IBlockReader)worldIn, pos);
        spawner.updateRedstone();
    }

    public static boolean checkPermission(ServerPlayerEntity player) {
        if (!PixelmonConfigProxy.getGeneral().isSpawnersOpOnly() && player.func_184812_l_()) {
            return true;
        }
        if (PixelmonConfigProxy.getGeneral().isSpawnersOpOnly() && PlayerHelper.hasPermission(player, "pixelmon.spawner.use")) {
            return true;
        }
        ChatHandler.sendChat((Entity)player, "pixelmon.general.needop", new Object[0]);
        return false;
    }
}

