/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.BoundingBoxSet;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class MultiBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<MultiBlockPosition> MULTIPOS = EnumProperty.func_177709_a((String)"multipos", MultiBlockPosition.class);
    private static final Map<Block, BoundingBoxSet> BOUNDING_BOXES = new HashMap<Block, BoundingBoxSet>();
    protected int width;
    protected int length;
    protected double height;
    protected boolean jsonOffset;

    protected MultiBlock(AbstractBlock.Properties builder, int width, double height, int length) {
        this(builder, width, height, length, false);
    }

    protected MultiBlock(AbstractBlock.Properties builder, int width, double height, int length, boolean jsonOffset) {
        super(builder);
        this.width = width;
        this.height = height;
        this.length = length;
        this.jsonOffset = jsonOffset;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, MULTIPOS});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        AxisAlignedBB aabb = this.getMultiBlockBoundingBox(worldIn, pos, (MultiBlockPosition)((Object)state.func_177229_b(MULTIPOS)), (Direction)state.func_177229_b((Property)FACING));
        return VoxelShapes.func_197881_a((AxisAlignedBB)(aabb == null ? new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0) : aabb));
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    protected AxisAlignedBB getMultiBlockBoundingBox(IBlockReader worldIn, BlockPos pos, MultiBlockPosition multiPos, Direction facing) {
        BoundingBoxSet boundingBoxSet = BOUNDING_BOXES.computeIfAbsent((Block)this, block -> new BoundingBoxSet(this.getWidth(), this.getHeight(), this.getLength(), this.getJsonOffset()));
        if (worldIn.func_180495_p(pos).func_177230_c() != this) {
            return new AxisAlignedBB((double)this.getWidthOffset(), 0.0, (double)this.getLengthOffset(), (double)(this.getWidth() + this.getWidthOffset()), this.getHeight(), (double)(this.getLength() + this.getLengthOffset()));
        }
        if (multiPos == MultiBlockPosition.BASE) {
            if (facing == Direction.SOUTH) {
                return boundingBoxSet.AABBBaseSouth;
            }
            if (facing == Direction.NORTH) {
                return boundingBoxSet.AABBBaseNorth;
            }
            if (facing == Direction.EAST) {
                return boundingBoxSet.AABBBaseEast;
            }
            return boundingBoxSet.AABBBaseWest;
        }
        BlockPos base = this.findBaseBlock(worldIn, pos.func_239590_i_(), worldIn.func_180495_p(pos));
        return this.getMultiBlockBoundingBox(worldIn, base, MultiBlockPosition.BASE, (Direction)worldIn.func_180495_p(base).func_177229_b((Property)FACING)).func_72317_d((double)(base.func_177958_n() - pos.func_177958_n()), (double)(base.func_177956_o() - pos.func_177956_o()), (double)(base.func_177952_p() - pos.func_177952_p()));
    }

    int getWidthOffset() {
        if (this.jsonOffset && this.width > 2) {
            return -1;
        }
        return 0;
    }

    int getLengthOffset() {
        if (this.jsonOffset && this.length > 2) {
            return -1;
        }
        return 0;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return null;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (state.func_177229_b(MULTIPOS) == MultiBlockPosition.BASE) {
            return this.getTileEntity(world, state).orElse(null);
        }
        return null;
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
    }

    protected abstract Optional<TileEntity> getTileEntity(IBlockReader var1, BlockState var2);

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        MultiBlockPosition multiPos = (MultiBlockPosition)((Object)state.func_177229_b(MULTIPOS));
        BlockPos location = this.findBaseBlock((IBlockReader)world, pos.func_239590_i_(), state);
        if (location.func_218275_a() != pos.func_218275_a()) {
            state = world.func_180495_p(location);
            try {
                multiPos = (MultiBlockPosition)((Object)state.func_177229_b(MULTIPOS));
            }
            catch (Exception e) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
        }
        this.setMultiBlocksWidth(location, world, state);
        if (!player.func_184812_l_() && !world.field_72995_K) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184586_b(Hand.MAIN_HAND));
            List<ItemStack> drops = this.func_220076_a(state, lootcontext$builder);
            for (ItemStack drop : drops) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), drop);
                world.func_217376_c((Entity)itemEntity);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        MultiBlockPosition multiPos = (MultiBlockPosition)((Object)state.func_177229_b(MULTIPOS));
        if (multiPos != MultiBlockPosition.BASE) {
            return Collections.emptyList();
        }
        return super.func_220076_a(state, context);
    }

    public BlockPos findBaseBlock(IBlockReader world, BlockPos.Mutable pos, BlockState state) {
        if (state.func_177230_c() != this) {
            return pos;
        }
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        MultiBlockPosition multipos = (MultiBlockPosition)((Object)state.func_177229_b(MULTIPOS));
        if (multipos == MultiBlockPosition.TOP && world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() == this) {
            pos.func_189536_c(Direction.DOWN);
        } else if (multipos == MultiBlockPosition.BOTTOM && world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() == this) {
            pos.func_189534_c(facing, -1);
        } else {
            return new BlockPos((Vector3i)pos);
        }
        return this.findBaseBlock(world, pos, world.func_180495_p((BlockPos)pos));
    }

    private void setMultiBlocksWidth(BlockPos pos, World world, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (facing == Direction.EAST) {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, 0, l, state, world);
            }
        } else if (facing == Direction.NORTH) {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, l, 0, state, world);
            }
        } else if (facing == Direction.WEST) {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, 0, -1 * l, state, world);
            }
        } else {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, -1 * l, 0, state, world);
            }
        }
    }

    private void setMultiBlocksLength(BlockPos pos, int xd, int zd, BlockState state, World world) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (facing == Direction.EAST) {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd + w, zd, state, world);
            }
        } else if (facing == Direction.NORTH) {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd, zd - w, state, world);
            }
        } else if (facing == Direction.WEST) {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd - w, zd, state, world);
            }
        } else {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd, zd + w, state, world);
            }
        }
    }

    private void setMultiBlocksHeight(BlockPos pos, int xd, int zd, BlockState state, World world) {
        int h = 0;
        while ((double)h < this.getHeight()) {
            BlockPos p = new BlockPos(pos.func_177958_n() + xd, pos.func_177956_o() + h, pos.func_177952_p() + zd);
            world.func_217377_a(p, false);
            ++h;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean getJsonOffset() {
        return this.jsonOffset;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }
}

