/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.StickyHold;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.MemoryItem;
import com.pixelmonmod.pixelmon.items.heldItems.PlateItem;
import com.pixelmonmod.pixelmon.items.heldItems.RustedShieldItem;
import com.pixelmonmod.pixelmon.items.heldItems.RustedSwordItem;
import java.util.List;

public class CorrosiveGas
extends StatusBase {
    public CorrosiveGas() {
        super(StatusType.CorrosiveGas);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.addStatus(new CorrosiveGas(), target)) {
            user.bc.sendToAll("pixelmon.status.corrosivegas", target.getNickname());
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.getBattleAbility() instanceof StickyHold || pokemon.getHeldItem() instanceof MemoryItem && pokemon.getSpecies().is(PixelmonSpecies.SILVALLY) || pokemon.getHeldItem() instanceof RustedSwordItem && pokemon.getSpecies().is(PixelmonSpecies.ZACIAN) || pokemon.getHeldItem() instanceof RustedShieldItem && pokemon.getSpecies().is(PixelmonSpecies.ZAMAZENTA) || pokemon.getHeldItem() == PixelmonItems.blue_orb && pokemon.getSpecies().is(PixelmonSpecies.KYOGRE) || pokemon.getHeldItem() == PixelmonItems.red_orb && pokemon.getSpecies().is(PixelmonSpecies.GROUDON) || pokemon.getHeldItem() instanceof MemoryItem && pokemon.getSpecies().is(PixelmonSpecies.SILVALLY) || pokemon.getHeldItem() instanceof PlateItem && pokemon.getSpecies().is(PixelmonSpecies.ARCEUS) || (pokemon.getHeldItem() == PixelmonItems.burn_drive || pokemon.getHeldItem() == PixelmonItems.chill_drive || pokemon.getHeldItem() == PixelmonItems.shock_drive || pokemon.getHeldItem() == PixelmonItems.douse_drive) && pokemon.getSpecies().is(PixelmonSpecies.GENESECT) || pokemon.getHeldItem() == PixelmonItems.griseous_orb && pokemon.getSpecies().is(PixelmonSpecies.GIRATINA);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            HeldItem heldItem = target.getUsableHeldItem();
            if (heldItem == null || heldItem.hasNegativeEffect()) continue;
            userChoice.raiseWeight(15.0f);
        }
    }
}

