/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.log.action.type;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.log.action.PokemonRelatedBattleAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.Arrays;
import java.util.StringJoiner;

public class AttackAction
extends PokemonRelatedBattleAction {
    protected final String pokemonName;
    protected final String participantName;
    protected final boolean wildPokemon;
    protected final Attack attack;
    protected final String[] targets;
    protected final MoveResults[] moveResults;

    public AttackAction(int turn, PixelmonWrapper pokemon, Attack attack, PixelmonWrapper[] targets, MoveResults[] moveResults) {
        super(turn, pokemon);
        this.pokemonName = pokemon.getPokemonName();
        this.wildPokemon = this.isWildPokemon(pokemon.getParticipant());
        this.participantName = this.wildPokemon ? null : pokemon.getParticipant().getDisplayName();
        this.targets = (String[])Arrays.stream(targets).map(PixelmonWrapper::getPokemonName).toArray(String[]::new);
        this.moveResults = moveResults;
        this.attack = attack.deepCopy();
    }

    @Override
    public boolean appendLog(StringBuilder builder) {
        if (this.participantName != null) {
            builder.append(this.participantName).append(" told ");
        }
        builder.append(this.pokemonName);
        if (this.wildPokemon) {
            builder.append(" used ");
        } else {
            builder.append(" to use ");
        }
        builder.append(this.attack.getMove().getAttackName()).append(" against ");
        StringJoiner joiner = new StringJoiner(" and ");
        for (String target : this.targets) {
            joiner.add(target + " with results " + this.getResults(target));
        }
        builder.append(joiner);
        return true;
    }

    public MoveResults[] getMoveResults() {
        return this.moveResults;
    }

    private MoveResults getResults(String wrapper) {
        for (MoveResults moveResult : this.moveResults) {
            if (moveResult == null || moveResult.getTarget() == null || !moveResult.getTarget().getPokemonName().equalsIgnoreCase(wrapper)) continue;
            return moveResult;
        }
        return null;
    }

    protected boolean isWildPokemon(BattleParticipant participant) {
        return participant.getType() == ParticipantType.WildPokemon || participant.getType() == ParticipantType.RaidPokemon;
    }
}

