/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystem;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackStatChange
extends AttackSystem<StatChangeData> {
    static final int PARTICLES_PER_STAGE = 8;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        PixelmonEntity p = (PixelmonEntity)w.func_73045_a(this.getEndID());
        float radius = p == null ? 2.0f : p.func_213311_cf();
        double randomisation = (double)w.func_201674_k().nextFloat() * Math.PI * 2.0;
        double dTheta = 0.7853981633974483;
        float top = this.getEndPos()[1] + 4.0f;
        float bot = this.getEndPos()[1] + 0.25f;
        if (((StatChangeData)this.getData()).getStages() < 0) {
            float temp = top;
            top = bot;
            bot = temp;
        }
        for (int i = 0; i < Math.abs(((StatChangeData)this.getData()).getStages()); ++i) {
            for (int j = 0; j < 8; ++j) {
                float startX = (float)((double)this.getEndPos()[0] + (double)radius * Math.cos(randomisation + dTheta * (double)j));
                float startZ = (float)((double)this.getEndPos()[2] + (double)radius * Math.sin(randomisation + dTheta * (double)j));
                mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(startX, bot, startZ, 0.0, 0.0, 0.0, ((StatChangeData)this.getData()).makeEffect(this).setNoise(0.0).setStartPos(startX, bot, startZ).setEndPos(startX, top, startZ).setHideTicks(i * 8, true)));
            }
        }
    }

    public static class StatChangeData
    extends StandardParticleAnimationData {
        private BattleStatsType stat;
        private int stages;

        public StatChangeData() {
        }

        public StatChangeData(BattleStatsType stat, int stages) {
            this.stat = stat;
            this.stages = stages;
        }

        @Override
        public EffectType getEffectEnum() {
            return EffectType.STAT_CHANGE;
        }

        public StatChangeData setStat(BattleStatsType stat) {
            this.stat = stat;
            return this;
        }

        public StatChangeData setStages(int stages) {
            this.stages = stages;
            return this;
        }

        @Override
        public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
            if (this.getSpeed() == -1.0f) {
                this.setSpeed(0.15f);
            }
            if (this.stat == null) {
                this.stat = BattleStatsType.ATTACK;
            }
            if (this.stages == 0) {
                this.stages = 1;
            }
            if (this.getScale() <= 0.0f) {
                this.setScale(0.16f);
            }
            if (this.getRGB() == null) {
                switch (this.stat) {
                    case ATTACK: {
                        this.setRGB(237, 165, 64);
                        break;
                    }
                    case DEFENSE: {
                        this.setRGB(99, 171, 94);
                        break;
                    }
                    case SPECIAL_ATTACK: {
                        this.setRGB(228, 32, 48);
                        break;
                    }
                    case SPECIAL_DEFENSE: {
                        this.setRGB(147, 194, 26);
                        break;
                    }
                    case SPEED: {
                        this.setRGB(16, 168, 246);
                        break;
                    }
                    case EVASION: {
                        this.setRGB(206, 84, 236);
                        break;
                    }
                    case ACCURACY: {
                        this.setRGB(255, 204, 255);
                    }
                }
            }
            if (this.getTexture() == null) {
                this.setTexture(this.stages < 0 ? AttackEffect.EnumParticleTexture.DOWN_ARROW : AttackEffect.EnumParticleTexture.UP_ARROW);
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeBoolean(this.stat != null);
            if (this.stat != null) {
                buf.writeByte(this.stat.ordinal());
            }
            buf.writeByte(this.stages);
        }

        @Override
        public StatChangeData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            if (buf.readBoolean()) {
                this.stat = BattleStatsType.values()[buf.readByte()];
            }
            this.stages = buf.readByte();
            return this;
        }

        public BattleStatsType getStat() {
            return this.stat;
        }

        public int getStages() {
            return this.stages;
        }
    }
}

