/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.api.SpecificationTypeAdapter;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnConditionTypeAdapter;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnInfoTypeAdapter;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnSetTypeAdapter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;

public class SpawnSet
implements Iterable<SpawnInfo> {
    public static final Class<? extends SpawnSet> CLASS = SpawnSet.class;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(PokemonSpecification.class, new SpecificationTypeAdapter(PokemonSpecification.class)).registerTypeAdapter(SpawnSet.class, (Object)new SpawnSetTypeAdapter()).registerTypeAdapter(SpawnInfo.class, (Object)new SpawnInfoTypeAdapter()).registerTypeAdapter(SpawnCondition.class, (Object)new SpawnConditionTypeAdapter()).create();
    public String id;
    public Float setSpecificShinyRate = null;
    public Float setSpecificPokerusRate = null;
    public ArrayList<SpawnInfo> spawnInfos = new ArrayList();

    public void onImport() {
        for (SpawnInfo spawnInfo : this.spawnInfos) {
            try {
                spawnInfo.set = this;
            }
            catch (NullPointerException e) {
                System.out.println(this.id);
            }
            spawnInfo.onImport();
        }
    }

    public ArrayList<SpawnInfo> suitableSpawnsFor(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitableSpawns = new ArrayList<SpawnInfo>();
        for (SpawnInfo spawnInfo : this.spawnInfos) {
            if (!(spawnInfo.rarity >= 0.0f) && spawnInfo.percentage == null || !spawnInfo.fits(spawner, spawnLocation)) continue;
            suitableSpawns.add(spawnInfo);
        }
        return suitableSpawns;
    }

    public static SpawnSet deserialize(Reader reader) {
        return SpawnSet.deserialize(reader, CLASS);
    }

    public static SpawnSet deserialize(Reader reader, Class<? extends SpawnSet> targetedSpawnSetClass) {
        return (SpawnSet)GSON.fromJson(reader, targetedSpawnSetClass);
    }

    public static SpawnSet deserialize(String contents) {
        return SpawnSet.deserialize(contents, CLASS);
    }

    public static SpawnSet deserialize(String contents, Class<? extends SpawnSet> targetedSpawnSetClass) {
        return (SpawnSet)GSON.fromJson(contents, targetedSpawnSetClass);
    }

    @Override
    public Iterator<SpawnInfo> iterator() {
        return new Iterator<SpawnInfo>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < SpawnSet.this.spawnInfos.size();
            }

            @Override
            public SpawnInfo next() {
                return SpawnSet.this.spawnInfos.get(this.index++);
            }
        };
    }
}

