/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.replacement;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.api.replacement.SpawnReplacementLogic;
import com.pixelmonmod.pixelmon.api.replacement.logic.BeeReplacementLogic;
import com.pixelmonmod.pixelmon.api.replacement.logic.NoReplacementLogic;
import com.pixelmonmod.pixelmon.api.replacement.logic.SimpleReplacementLogic;
import com.pixelmonmod.pixelmon.api.replacement.logic.TrainerReplacementLogic;
import com.pixelmonmod.pixelmon.api.replacement.logic.VillagerReplacementLogic;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class ReplacementLogicRegistry {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<String, Supplier<SpawnReplacementLogic>> SPAWN_REPLACEMENT_LOGIC = Maps.newHashMap();

    public static <T extends SpawnReplacementLogic> Optional<T> get(String type) {
        Supplier<SpawnReplacementLogic> supplier = SPAWN_REPLACEMENT_LOGIC.get(type.toLowerCase());
        if (supplier == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(supplier.get());
    }

    public static void register(Supplier<? extends SpawnReplacementLogic> replacementLogic) {
        SPAWN_REPLACEMENT_LOGIC.put(replacementLogic.get().getId().toLowerCase(), replacementLogic);
    }

    static {
        ReplacementLogicRegistry.register(NoReplacementLogic::new);
        ReplacementLogicRegistry.register(SimpleReplacementLogic::new);
        ReplacementLogicRegistry.register(TrainerReplacementLogic::new);
        ReplacementLogicRegistry.register(VillagerReplacementLogic::new);
        ReplacementLogicRegistry.register(BeeReplacementLogic::new);
    }
}

