/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.links;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUpPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class WrapperLink
extends PokemonLink {
    private PixelmonWrapper pixelmon;
    private Pokemon innerLink;

    public WrapperLink(PixelmonWrapper pixelmon) {
        this.pixelmon = pixelmon;
        this.innerLink = pixelmon.getInnerLink();
    }

    @Override
    public Pokemon getPokemon() {
        return this.innerLink;
    }

    @Override
    public PermanentStats getStats() {
        return this.pixelmon.getStats();
    }

    @Override
    public HeldItem getHeldItem() {
        return this.pixelmon.getHeldItem();
    }

    @Override
    public void setHeldItem(ItemStack item) {
        this.pixelmon.setHeldItem(item);
    }

    @Override
    public int getHealth() {
        return this.pixelmon.getHealth();
    }

    @Override
    public int getMaxHealth() {
        return this.getMaxHealth(false);
    }

    @Override
    public int getMaxHealth(boolean ignoreDynamax) {
        return this.pixelmon.getMaxHealth(ignoreDynamax);
    }

    @Override
    public void setHealth(int health) {
        int currentHealth = this.getHealth();
        if (health > currentHealth) {
            this.pixelmon.healEntityBy(health - currentHealth);
        } else if (health < currentHealth) {
            this.pixelmon.doBattleDamage(this.pixelmon, currentHealth - health, DamageTypeEnum.SELF);
        }
    }

    @Override
    public void setHealthDirect(int health) {
        this.pixelmon.setHealth(health);
    }

    @Override
    public int getPokemonLevel() {
        return this.pixelmon.getPokemonLevelNum();
    }

    @Override
    public void setLevel(int level) {
        this.pixelmon.setLevelNum(level);
    }

    @Override
    public int getExp() {
        return this.pixelmon.getExp();
    }

    @Override
    public void setExp(int experience) {
        this.pixelmon.setExp(experience);
    }

    @Override
    public int getFriendship() {
        return this.pixelmon.getFriendship();
    }

    @Override
    public boolean doesLevel() {
        return this.pixelmon.doesLevel();
    }

    @Override
    public ServerPlayerEntity getPlayerOwner() {
        return this.pixelmon.getPlayerOwner();
    }

    @Override
    public ITextComponent getRealNickname() {
        return this.pixelmon.getFormattedNickname();
    }

    @Override
    public BattleController getBattleController() {
        return this.pixelmon.bc;
    }

    @Override
    public Moveset getMoveset() {
        return this.pixelmon.getMoveset();
    }

    @Override
    public UUID getPokemonUUID() {
        return this.pixelmon.getPokemonUUID();
    }

    @Override
    public PixelmonEntity getEntity() {
        if (this.pixelmon.entity != null) {
            return this.pixelmon.entity;
        }
        BattleParticipant participant = this.pixelmon.getParticipant();
        return participant.getStorage().find(this.getPokemonUUID()).getOrSpawnPixelmon((Entity)participant.getEntity());
    }

    @Override
    public void setScale(float scale) {
    }

    @Override
    public World getWorld() {
        return this.pixelmon.getParticipant().getWorld();
    }

    @Override
    public Gender getGender() {
        return this.pixelmon.getGender();
    }

    @Override
    public BlockPos getPos() {
        PixelmonEntity entity = this.pixelmon.entity;
        if (this.pixelmon.entity == null) {
            entity = this.pixelmon.getParticipant().getEntity();
        }
        return entity.func_233580_cy_();
    }

    @Override
    public PartyStorage getStorage() {
        return this.pixelmon.getParticipant().getStorage();
    }

    @Override
    public void update(EnumUpdateType ... updateTypes) {
        this.pixelmon.update(updateTypes);
        for (EnumUpdateType updateType : updateTypes) {
            if (updateType != EnumUpdateType.Moveset) continue;
            this.getPokemonWrapper().setTemporaryMoveset(this.getPokemonWrapper().getMoveset());
        }
    }

    @Override
    public void updateStats() {
        this.pixelmon.getStats().setLevelStats(this.pixelmon.getNature(), this.pixelmon.getForm(), this.pixelmon.getPokemonLevelNum());
        this.pixelmon.update(EnumUpdateType.HP, EnumUpdateType.Stats);
    }

    @Override
    public void updateLevelUp(PixelmonStatsData stats) {
        ServerPlayerEntity owner = this.pixelmon.getPlayerOwner();
        if (owner != null) {
            PixelmonStatsData stats2 = PixelmonStatsData.createPacket(this);
            NetworkHelper.sendPacket(new LevelUpPacket(this.pixelmon.getPokemonUUID(), this.getPokemonLevel(), stats, stats2, new PixelmonClientData(this.getPokemon())), owner);
            this.pixelmon.updateHPIncrease();
        }
    }

    @Override
    public void sendMessage(String langKey, Object ... data) {
        this.pixelmon.bc.sendToAll(langKey, data);
    }

    @Override
    public ITextComponent getNickname() {
        return this.pixelmon.getFormattedNickname();
    }

    @Override
    public String getOriginalTrainer() {
        return this.pixelmon.getOriginalTrainer();
    }

    @Override
    public boolean removeStatuses(StatusType ... statuses) {
        return this.pixelmon.removeStatuses(statuses);
    }

    @Override
    public Nature getNature() {
        return this.pixelmon.getNature();
    }

    @Override
    public int getExpToNextLevel() {
        return this.pixelmon.getPokemonLevel().expToNextLevel;
    }

    @Override
    public StatusPersist getPrimaryStatus() {
        return this.pixelmon.getPrimaryStatus();
    }

    @Override
    public Ability getAbility() {
        return this.pixelmon.getAbility();
    }

    @Override
    public List<Element> getType() {
        return this.pixelmon.type;
    }

    @Override
    public String getForm() {
        return this.pixelmon.getForm().getName();
    }

    @Override
    public boolean isEgg() {
        return false;
    }

    @Override
    public int getEggCycles() {
        return 0;
    }

    @Override
    public int getPartyPosition() {
        return this.pixelmon.getPartyPosition();
    }

    @Override
    public boolean hasOwner() {
        return this.pixelmon.getParticipant().getType() != ParticipantType.WildPokemon;
    }

    @Override
    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.innerLink.getPokerus());
    }

    @Override
    public void adjustFriendship(int change) {
        if (change > 0) {
            this.pixelmon.getInnerLink().increaseFriendship(change);
        } else {
            this.pixelmon.getInnerLink().decreaseFriendship(-change);
        }
    }

    public PixelmonWrapper getPokemonWrapper() {
        return this.pixelmon;
    }
}

