/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare.impl.duration;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.daycare.impl.duration.AbstractDuration;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class AdditiveDuration
extends AbstractDuration {
    private long milliseconds;

    public AdditiveDuration() {
        super("add");
    }

    @Override
    public long getMillisecondValue(ServerPlayerEntity player, DayCareBox box, long currentTime) {
        return currentTime + this.milliseconds;
    }

    @Override
    public void read(Gson gson, JsonElement json) {
        JsonObject object = json.getAsJsonObject();
        TimeUnit unit = TimeUnit.valueOf(object.get("unit").getAsString().toUpperCase());
        this.milliseconds = unit.toMillis((long)object.get("amount").getAsDouble());
    }

    @Override
    public ITextComponent getDisplay() {
        return StringHelper.getFormattedDuration(this.milliseconds, true);
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }
}

