/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MultiplayerOptionsPacket {
    private String payload;

    public MultiplayerOptionsPacket() {
    }

    public MultiplayerOptionsPacket(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public MultiplayerOptionsPacket(PacketBuffer buf) {
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                this.payload = buf.func_150789_c(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for multiplayer options request: %s", t));
        }
    }

    public void encode(PacketBuffer buf) {
        try {
            if (this.payload != null) {
                buf.writeByte(42);
                buf.func_211400_a(this.payload, Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for multiplayer options request:" + t);
        }
    }

    public static void handle(MultiplayerOptionsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                if (packet.getPayload() == null) {
                    Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsOpen(((NetworkEvent.Context)ctx.get()).getSender());
                } else {
                    Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsSave(((NetworkEvent.Context)ctx.get()).getSender(), packet.getPayload());
                }
            } else {
                JourneymapClient.getInstance().getPacketHandler().onMultiplayerDataResponse(packet.getPayload());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

