/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.optifine.config.BiomeId;
import net.optifine.override.ChunkCacheOF;

public class BiomeUtils {
    private static gm<bsv> biomeRegistry = BiomeUtils.getBiomeRegistry((brx)djz.C().r);
    public static bsv PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, (vj<bsv>)btb.b, () -> ku.a((boolean)false));
    public static bsv SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, (vj<bsv>)btb.g, () -> ku.d((float)-0.2f, (float)0.1f, (boolean)false));
    public static bsv SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, (vj<bsv>)btb.af, () -> ku.d((float)-0.1f, (float)0.3f, (boolean)true));

    public static void onWorldChanged(brx worldIn) {
        biomeRegistry = BiomeUtils.getBiomeRegistry(worldIn);
        PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, (vj<bsv>)btb.b, () -> ku.a((boolean)false));
        SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, (vj<bsv>)btb.g, () -> ku.d((float)-0.2f, (float)0.1f, (boolean)false));
        SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, (vj<bsv>)btb.af, () -> ku.d((float)-0.1f, (float)0.3f, (boolean)true));
    }

    private static bsv getBiomeSafe(gm<bsv> registry, vj<bsv> biomeKey, Supplier<bsv> biomeDefault) {
        bsv biome = (bsv)registry.a(biomeKey);
        if (biome == null) {
            biome = biomeDefault.get();
        }
        return biome;
    }

    public static gm<bsv> getBiomeRegistry(brx worldIn) {
        if (worldIn != null) {
            return worldIn.r().b(gm.ay);
        }
        return hk.i;
    }

    public static gm<bsv> getBiomeRegistry() {
        return biomeRegistry;
    }

    public static vk getLocation(bsv biome) {
        return BiomeUtils.getBiomeRegistry().b((Object)biome);
    }

    public static int getId(bsv biome) {
        return BiomeUtils.getBiomeRegistry().a((Object)biome);
    }

    public static int getId(vk loc) {
        bsv biome = BiomeUtils.getBiome(loc);
        return BiomeUtils.getBiomeRegistry().a((Object)biome);
    }

    public static BiomeId getBiomeId(vk loc) {
        return BiomeId.make(loc);
    }

    public static bsv getBiome(vk loc) {
        return (bsv)BiomeUtils.getBiomeRegistry().a(loc);
    }

    public static Set<vk> getLocations() {
        return BiomeUtils.getBiomeRegistry().c();
    }

    public static List<bsv> getBiomes() {
        return Lists.newArrayList(biomeRegistry);
    }

    public static List<BiomeId> getBiomeIds() {
        return BiomeUtils.getBiomeIds(BiomeUtils.getLocations());
    }

    public static List<BiomeId> getBiomeIds(Collection<vk> locations) {
        ArrayList<BiomeId> biomeIds = new ArrayList<BiomeId>();
        for (vk loc : locations) {
            BiomeId bi = BiomeId.make(loc);
            if (bi == null) continue;
            biomeIds.add(bi);
        }
        return biomeIds;
    }

    public static bsv getBiome(bra lightReader, fx blockPos) {
        bsv biome = PLAINS;
        if (lightReader instanceof ChunkCacheOF) {
            biome = ((ChunkCacheOF)lightReader).getBiome(blockPos);
        } else if (lightReader instanceof brz) {
            biome = ((brz)lightReader).v(blockPos);
        }
        return biome;
    }
}

