/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.tree.berry.foliage;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraftforge.fml.RegistryObject;

public abstract class AbstractBerryTreeFoliagePlacer
extends FoliagePlacer {
    private static final FeatureSpread RADIUS = FeatureSpread.func_242252_a((int)2);
    private static final FeatureSpread OFFSET = FeatureSpread.func_242252_a((int)0);
    private RegistryObject<FoliagePlacerType<?>> foliagePlacerType;
    private final int foliageHeight;
    private final List<BlockPos> foliagePositions = Lists.newArrayList();
    private final List<Integer> fullRows = Lists.newArrayList();

    public AbstractBerryTreeFoliagePlacer(RegistryObject<FoliagePlacerType<?>> foliagePlacerType, int foliageHeight, List<Integer> fullRows, BlockPos ... foliagePositions) {
        super(RADIUS, OFFSET);
        this.foliagePlacerType = foliagePlacerType;
        this.foliageHeight = foliageHeight;
        this.foliagePositions.addAll(Arrays.asList(foliagePositions));
        this.fullRows.addAll(fullRows);
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return FoliagePlacerType.field_227389_d_;
    }

    protected void func_230372_a_(IWorldGenerationReader worldGenReader, Random random, BaseTreeFeatureConfig config, int unknown, FoliagePlacer.Foliage foliage, int foliageHeight, int radius, Set<BlockPos> blockSet, int treeTopHeight, MutableBoundingBox mutableBoundingBox) {
        Boolean doubleTrunk = foliage.func_236765_c_();
        BlockPos foliagePos = foliage.func_236763_a_();
        for (Integer pos : this.fullRows) {
            this.func_236753_a_(worldGenReader, random, config, foliagePos, 2, blockSet, pos, doubleTrunk, mutableBoundingBox);
        }
        for (BlockPos foliagePosition : this.foliagePositions) {
            this.setBlock(worldGenReader, random, config, blockSet, foliagePos.func_177971_a((Vector3i)foliagePosition).func_239590_i_(), mutableBoundingBox);
        }
    }

    private void setBlock(IWorldGenerationReader worldGenReader, Random random, BaseTreeFeatureConfig config, Set<BlockPos> blockSet, BlockPos.Mutable pos, MutableBoundingBox mutableBoundingBox) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)worldGenReader, (BlockPos)pos)) {
            worldGenReader.func_180501_a((BlockPos)pos, config.field_227369_n_.func_225574_a_(random, (BlockPos)pos), 19);
            mutableBoundingBox.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
            blockSet.add(pos.func_185334_h());
        }
    }

    public int func_230374_a_(Random p_230374_1_, int p_230374_2_, BaseTreeFeatureConfig p_230374_3_) {
        return this.foliageHeight;
    }

    protected boolean func_230373_a_(Random random, int x, int y, int z, int radius, boolean doubleTrunk) {
        return x * x + z * z > radius;
    }
}

