/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.CheckPokemonEditorAllowedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditedPlayerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateSinglePokemonPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class PokemonEditorItem
extends PixelmonItem {
    public PokemonEditorItem() {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_UTILITY).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && player.func_184812_l_() && hand == Hand.MAIN_HAND && PokemonEditorItem.checkPermission((ServerPlayerEntity)player)) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            PlayerPartyStorage party = StorageProxy.getParty(playerMP);
            party.retrieveAll("PokemonEditor");
            NetworkHelper.sendPacket(new SetEditedPlayerPacket(player.func_110124_au(), player.func_145748_c_().getString(), party.getAll()), playerMP);
            OpenScreenPacket.open(player, EnumGuiScreen.PokemonEditor, new int[0]);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (entity instanceof ServerPlayerEntity && player.func_184812_l_()) {
            if (PokemonEditorItem.checkPermission((ServerPlayerEntity)player)) {
                ServerPlayerEntity otherPlayer = (ServerPlayerEntity)entity;
                PlayerPartyStorage party = StorageProxy.getParty(otherPlayer);
                if (party.guiOpened) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.general.playerbusy", new Object[0]);
                    return true;
                }
                NetworkHelper.sendPacket(new CheckPokemonEditorAllowedPacket(player.func_110124_au()), otherPlayer);
            }
            return true;
        }
        return false;
    }

    public static void updateEditedPlayer(ServerPlayerEntity editingPlayer, UUID editedPlayer) {
        if (!PokemonEditorItem.checkPermission(editingPlayer)) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(editedPlayer);
        NetworkHelper.sendPacket(new SetEditedPlayerPacket(editedPlayer, party.getAll()), editingPlayer);
    }

    public static void updateSinglePokemon(ServerPlayerEntity editingPlayer, UUID editedPlayer, int slot) {
        if (!PokemonEditorItem.checkPermission(editingPlayer)) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(editedPlayer);
        Pokemon pokemonData = party.get(slot);
        NetworkHelper.sendPacket(new UpdateSinglePokemonPacket(slot, pokemonData), editingPlayer);
    }

    public static boolean checkPermission(ServerPlayerEntity editingPlayer) {
        if (PixelmonConfigProxy.getGeneral().isAllowPokemonEditors() && PlayerHelper.hasPermission(editingPlayer, "pixelmon.pokemoneditor.use")) {
            return true;
        }
        ChatHandler.sendChat((Entity)editingPlayer, "gui.pokemoneditor.notallowedserver", new Object[0]);
        return false;
    }
}

