/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.init.registry;

import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelPredicateType;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.AlwaysModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.BattleModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.FlyingModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.RidingModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.WalkingModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.MovementType;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.mounted.MountedFlyingParameters;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PixelmonRegistry {
    private static final int MAX_VARINT = 0x7FFFFFFE;
    public static RegistryKey<Registry<MovementType<?>>> MOVEMENT_LOGIC_TYPES_REGISTRY = RegistryKey.func_240904_a_((ResourceLocation)ResourceLocationHelper.of("pixelmon", "movement_logic_type"));
    public static RegistryKey<Registry<ModelPredicateType<?>>> MODEL_PREDICATE_TYPES_REGISTRY = RegistryKey.func_240904_a_((ResourceLocation)ResourceLocationHelper.of("pixelmon", "model_predicate_type"));
    public static IForgeRegistry<MovementType<?>> movementLogicTypes;
    public static IForgeRegistry<ModelPredicateType<?>> modelPredicateTypes;

    @SubscribeEvent
    public static void onRegistry(RegistryEvent.NewRegistry event) {
        movementLogicTypes = PixelmonRegistry.makeRegistry(MOVEMENT_LOGIC_TYPES_REGISTRY, PixelmonRegistry.classOf(MovementType.class)).disableSync().disableSaving().allowModification().create();
        modelPredicateTypes = PixelmonRegistry.makeRegistry(MODEL_PREDICATE_TYPES_REGISTRY, PixelmonRegistry.classOf(ModelPredicateType.class)).disableSaving().disableSaving().allowModification().create();
    }

    @SubscribeEvent
    public static void onRegister(RegistryEvent.Register event) {
        if (event.getName() == MOVEMENT_LOGIC_TYPES_REGISTRY.func_240901_a_()) {
            event.getRegistry().register(new MovementType<MountedFlyingParameters>(MountedFlyingParameters.CODEC).setRegistryName(ResourceLocationHelper.of("pixelmon", "default")));
        }
        if (event.getName() == MODEL_PREDICATE_TYPES_REGISTRY.func_240901_a_()) {
            event.getRegistry().register(new ModelPredicateType<AlwaysModelPredicate>(AlwaysModelPredicate.CODEC).setRegistryName(ResourceLocationHelper.of("pixelmon", "always")));
            event.getRegistry().register(new ModelPredicateType<FlyingModelPredicate>(FlyingModelPredicate.CODEC).setRegistryName(ResourceLocationHelper.of("pixelmon", "flying")));
            event.getRegistry().register(new ModelPredicateType<RidingModelPredicate>(RidingModelPredicate.CODEC).setRegistryName(ResourceLocationHelper.of("pixelmon", "riding")));
            event.getRegistry().register(new ModelPredicateType<BattleModelPredicate>(BattleModelPredicate.CODEC).setRegistryName(ResourceLocationHelper.of("pixelmon", "battle")));
            event.getRegistry().register(new ModelPredicateType<WalkingModelPredicate>(WalkingModelPredicate.CODEC).setRegistryName(ResourceLocationHelper.of("pixelmon", "walk")));
        }
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(RegistryKey<? extends Registry<T>> key, Class<T> type) {
        return new RegistryBuilder().setName(key.func_240901_a_()).setType(type).setMaxID(0x7FFFFFFE);
    }

    private static <T> Class<T> classOf(Class<?> clazz) {
        return clazz;
    }
}

