/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.item.JsonItemStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class EvolutionStrategy
extends WikiCommandStrategy {
    public EvolutionStrategy() {
        super("evolution");
    }

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    public Optional<ITextComponent> getBanner(CommandSource sender, Pokemon pokemon, String[] args) {
        if (pokemon.getForm().getEvolutions().isEmpty()) {
            return Optional.empty();
        }
        return super.getBanner(sender, pokemon, args);
    }

    @Override
    public void execute(CommandSource sender, Pokemon pokemon, String[] args) {
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.header", PokemonHelper.getFullName(pokemon).func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.BOLD})), false);
        for (Evolution evo : pokemon.getForm().getEvolutions()) {
            if (evo instanceof LevelingEvolution) {
                LevelingEvolution leveling = (LevelingEvolution)evo;
                if (leveling.level == null) {
                    sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.leveling.nospecification", evo.to.create().getLocalizedName())), false);
                } else {
                    int level = ((LevelingEvolution)evo).level;
                    sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.leveling", evo.to.create().getLocalizedName(), level)), false);
                }
            } else if (evo instanceof InteractEvolution) {
                JsonItemStack item = ((InteractEvolution)evo).item;
                sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.interact", evo.to.create().getLocalizedName(), item.getItemStack().func_200301_q().getString())), false);
            } else {
                sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution." + evo.evoType, evo.to.create().getLocalizedName())), false);
            }
            if (evo.conditions.isEmpty()) continue;
            sender.func_197030_a((ITextComponent)TextHelper.space(3).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.conditions.header", new Object[0])), false);
            for (EvoCondition condition : evo.conditions) {
                IFormattableTextComponent text = condition.getDescription();
                if (text == null) continue;
                sender.func_197030_a((ITextComponent)TextHelper.space(5).func_230529_a_((ITextComponent)text), false);
            }
        }
    }
}

