/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;

public class PokeCloneCommand
extends PixelCommand {
    public PokeCloneCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokeclone", "/pokeclone [player] <slot>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = this.setupTargetOrSourceAsTarget(sender, args, 0)).length != 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.invalidslot", args[1]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", target.func_200200_C_().getString());
        CompoundNBT nbt = new CompoundNBT();
        pokemon.writeToNBT(nbt);
        Pokemon clone = PokemonFactory.create(nbt);
        clone.setUUID(UUID.randomUUID());
        PokemonReceivedEvent event = new PokemonReceivedEvent(target, clone, "Command");
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        storage.add(clone);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokeclone.success", target.func_145748_c_().getString(), pokemon.getDisplayName()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (!hasPermissionOtherTarget) break;
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

