/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ExpCharmCommand
extends PixelCommand {
    public ExpCharmCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "expcharm", "/expcharm [player]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if (args.length <= 2) {
            args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0);
            ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
            PlayerPartyStorage party = PixelmonCommandUtils.getPlayerStorage(player);
            EnumFeatureState newState = args.length == 2 && args[1].equalsIgnoreCase("remove") ? EnumFeatureState.Disabled : EnumFeatureState.Active;
            party.setExpCharm(newState);
            if (sender.func_197022_f() != player) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.expcharm.success", player.func_200200_C_());
            }
            if (newState.equals((Object)EnumFeatureState.Active)) {
                PixelmonCommandUtils.sendMessage(player, "pixelmon.command.expcharm.received", new Object[0]);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.expcharm.notify.received", sender.func_197037_c(), player.func_200200_C_());
            } else {
                PixelmonCommandUtils.sendMessage(player, "pixelmon.command.expcharm.removed", new Object[0]);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.expcharm.notify.removed", sender.func_197037_c(), player.func_200200_C_());
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length <= 2) {
            return PixelmonCommandUtils.REMOVE_ARGUMENT;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

