/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.CommandHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CompSeeCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pokecompsee", "pcompsee"});

    public CompSeeCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "compsee", "/compsee [player] <box>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        int box;
        ServerPlayerEntity player;
        PCStorage storage;
        List<ITextComponent> pokemonList;
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        if ((pokemonList = this.searchComputerPokemon((storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(player = PixelmonCommandUtils.requireEntityPlayer(args[0])), "pixelmon.command.general.invalidplayer", new Object[0])).getBox((box = PixelmonCommandUtils.requireInt(args.length >= 3 ? args[2] : args[1], 1, PixelmonConfigProxy.getStorage().getComputerBoxes(), "pixelmon.command.compsee.notspecified", new Object[0])) - 1))).isEmpty()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.compsee.noresults", new Object[0]);
        }
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.AQUA, "pixelmon.command.compsee.header", player.func_200200_C_().getString(), box + ""), false);
        for (ITextComponent c : pokemonList) {
            sender.func_197030_a(c, false);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return IntStream.range(1, PixelmonConfigProxy.getStorage().getComputerBoxes()).mapToObj(String::valueOf).collect(Collectors.toList());
    }

    private List<ITextComponent> searchComputerPokemon(PCBox box) {
        int boxLimit = 30;
        ArrayList pokemonList = Lists.newArrayList();
        for (int slot = 0; slot < boxLimit; ++slot) {
            Pokemon pokemon = box.get(slot);
            if (pokemon == null) continue;
            pokemonList.add(CommandHelper.getHoverTextPokemon(pokemon, box.boxNumber, slot + 1));
        }
        return pokemonList;
    }
}

