/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CheckSpawnsCommand
extends PixelCommand {
    public CheckSpawnsCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "checkspawns", "/checkspawns [specific] [pokemon...]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        ArrayList<String> arguments = new ArrayList<String>();
        AbstractSpawner spawner = null;
        for (String arg : args) {
            arguments.add(arg);
            if (spawner != null) continue;
            spawner = PixelmonSpawning.coordinator.getSpawner(arg);
        }
        if (spawner == null) {
            if (sender.func_197022_f() instanceof ServerPlayerEntity) {
                spawner = PixelmonSpawning.coordinator.getSpawner(sender.func_197037_c());
            } else {
                PixelmonCommandUtils.endCommand("spawning.error.mustbeplayer", new Object[0]);
            }
        }
        AbstractSpawner fSpawner = PixelmonCommandUtils.require(spawner, "pixelmon.general.error", new Object[0]);
        if (!PixelmonCommandUtils.hasPermission(sender, fSpawner.checkSpawns.getPermissionNode())) {
            PixelmonCommandUtils.endCommand("pixelmon.general.needop", new Object[0]);
        }
        fSpawner.checkSpawns.checkSpawns(fSpawner, sender, arguments);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        if (PixelmonSpawning.coordinator != null) {
            ArrayList list = Lists.newArrayList();
            PixelmonSpawning.coordinator.spawners.forEach(s -> list.add(s.name));
            return args.length == 1 ? list : Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

