/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemonPacket;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class EnforcedRevivePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;

    public EnforcedRevivePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public EnforcedRevivePacket(UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.pokemonUUID);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokemonUUID = buffer.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        BattleController bc = BattleRegistry.getBattle((PlayerEntity)player);
        if (bc == null) {
            return;
        }
        PlayerParticipant playerParticipant = bc.getPlayer((PlayerEntity)player);
        if (!playerParticipant.enforcedRevive) {
            return;
        }
        UUID toBeRevivedPokemonUUID = this.pokemonUUID == null ? playerParticipant.getBattleAI().getFaintedPokemonToRevive() : this.pokemonUUID;
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Pokemon pokemon = party.find(toBeRevivedPokemonUUID);
        if (pokemon != null && pokemon.isFainted()) {
            pokemon.setHealthPercentage(50.0f);
            NetworkHelper.sendPacket(new SetAllBattlingPokemonPacket(PixelmonClientData.convertToGUI(Arrays.asList(playerParticipant.allPokemon)), false), player);
        }
        playerParticipant.enforcedRevive = false;
        for (PixelmonWrapper pw : playerParticipant.getActiveUnfaintedPokemon()) {
            if (!pw.wait) continue;
            pw.wait = false;
        }
    }
}

