/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers.npc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.NPCRenderer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.enums.CustomModel;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;

public class LayerMegaItemsNPC
extends LayerRenderer<NPCEntity, PlayerModel<NPCEntity>> {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/megabraceletoras.png");
    private static final ResourceLocation NECKLACE_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/boost_necklace.png");
    private static final ResourceLocation GLASSES_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_glasses.png");
    private static final ResourceLocation ANCHOR_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_anchor.png");
    private static final ResourceLocation DYNAMAX_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/dynamax_band.png");
    private final Model braceletModel = CustomModel.MEGA_BRACELET_ORAS.getModel();
    private final Model stoneModel = CustomModel.MEGA_BRACELET_ORAS_STONE.getModel();
    private final Model necklace = CustomModel.MEGA_BOOST_NECKLACE.getModel();
    private final Model glasses = CustomModel.MEGA_GLASSES.getModel();
    private final Model anchor = CustomModel.MEGA_ANCHOR.getModel();
    private final Model dynamax = CustomModel.DYNAMAX_BAND.getModel();
    private final NPCRenderer renderer;
    private float scale = 1.0f;

    public LayerMegaItemsNPC(NPCRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, NPCEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof NPCTrainer)) {
            return;
        }
        NPCTrainer trainer = (NPCTrainer)entity;
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)entity, (float)0.0f);
        boolean oldGenWorld = PixelmonConfigProxy.getGeneral().getOldGenDimensions().contains(entity.field_70170_p.func_234923_W_().toString());
        EnumOldGenMode oldGenMode = trainer.getOldGen();
        EnumMegaItemsUnlocked itemInUse = trainer.getMegaItem();
        EnumMegaItem megaItem = EnumMegaItem.None;
        if (oldGenMode == EnumOldGenMode.World) {
            if (oldGenWorld && itemInUse.canMega()) {
                megaItem = EnumMegaItem.BraceletORAS;
            } else if (!oldGenWorld && itemInUse.canDynamax()) {
                megaItem = EnumMegaItem.DynamaxBand;
            }
        } else if (oldGenMode == EnumOldGenMode.Mega && itemInUse.canMega()) {
            megaItem = EnumMegaItem.BraceletORAS;
        } else if (oldGenMode == EnumOldGenMode.Dynamax && itemInUse.canDynamax()) {
            megaItem = EnumMegaItem.DynamaxBand;
        }
        if (megaItem == EnumMegaItem.None || trainer.func_82150_aj()) {
            return;
        }
        PlayerModel biped = (PlayerModel)this.renderer.func_217764_d();
        ModelRenderer left = biped.field_178724_i;
        matrix.func_227860_a_();
        if (megaItem == EnumMegaItem.BraceletORAS) {
            if (entity.func_225608_bj_()) {
                matrix.func_227861_a_(0.0, (double)0.2f, 0.0);
            }
            this.scale = !left.field_78804_l.isEmpty() && ((ModelRenderer.ModelBox)left.field_78804_l.get((int)0)).field_78248_d == 2.0f ? 0.17f : 0.19f;
            biped.func_225599_a_(HandSide.LEFT, matrix);
            matrix.func_227861_a_(0.0, (double)0.4f, 0.0);
            matrix.func_227862_a_(this.scale, this.scale, this.scale);
            matrix.func_227861_a_((double)0.35f, 0.0, 0.0);
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(TEXTURE));
            ((ValveStudioModel)this.braceletModel).animate();
            this.braceletModel.func_225598_a_(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            ((ValveStudioModel)this.stoneModel).animate();
            this.stoneModel.func_225598_a_(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.4f);
        } else {
            if (entity.func_225608_bj_()) {
                matrix.func_227861_a_(0.0, (double)0.2f, 0.0);
            }
            this.scale = 1.05f;
            if (!left.field_78804_l.isEmpty() && ((ModelRenderer.ModelBox)left.field_78804_l.get((int)0)).field_78248_d == 2.0f) {
                this.scale = 1.02f;
            }
            biped.func_225599_a_(HandSide.LEFT, matrix);
            matrix.func_227861_a_(0.0, (double)0.4f, 0.0);
            matrix.func_227862_a_(this.scale, this.scale, this.scale);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            matrix.func_227861_a_((double)-0.3f, 0.0, 0.875);
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(DYNAMAX_TEXTURE));
            ((ValveStudioModel)this.dynamax).animate();
            this.dynamax.func_225598_a_(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrix.func_227865_b_();
    }
}

