/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.music;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundSystem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT})
public class PixelmonMusic {
    public static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_music_%d").build());
    private static MusicTicker mcMusicTicker;
    private static SoundHandler mcSoundHandler;
    private static SoundEngine mcSoundManager;
    private static SoundSystem soundSystem;
    private static final Map<ISound, Float> FADE;

    @SubscribeEvent
    public static void onSoundReloadEvent(SoundLoadEvent event) {
        CompletableFuture future = new CompletableFuture();
        ScheduledFuture<?> scheduledFuture = EXECUTOR.scheduleWithFixedDelay(() -> {
            if (((Boolean)ObfuscationReflectionHelper.getPrivateValue(SoundEngine.class, (Object)mcSoundManager, (String)"field_148617_f")).booleanValue()) {
                PixelmonMusic.init(Minecraft.func_71410_x());
                future.complete(null);
            }
        }, 10L, 10L, TimeUnit.MILLISECONDS);
        future.thenAccept(v -> scheduledFuture.cancel(false));
    }

    public static void init(Minecraft mc) {
        if (mcMusicTicker == null) {
            mcMusicTicker = mc.func_181535_r();
        }
        mcSoundHandler = mc.func_147118_V();
        mcSoundManager = (SoundEngine)ObfuscationReflectionHelper.getPrivateValue(SoundHandler.class, (Object)mcSoundHandler, (String)"field_147694_f");
        soundSystem = (SoundSystem)ObfuscationReflectionHelper.getPrivateValue(SoundEngine.class, (Object)mcSoundManager, (String)"field_217937_g");
    }

    public static MusicTicker getMusicTicker() {
        return mcMusicTicker;
    }

    public static SoundHandler getSoundHandler() {
        return mcSoundHandler;
    }

    public static SoundEngine getSoundManager() {
        return mcSoundManager;
    }

    public static SoundSystem getSoundSystem() {
        return soundSystem;
    }

    public static void fadeSoundToStart(ISound sound, long millis) {
        if (!mcSoundManager.func_217933_b(sound)) {
            PixelmonMusic.fadeSoundToStartInternal(sound, millis);
        }
    }

    private static void fadeSoundToStartInternal(ISound sound, long millis) {
        try {
            EXECUTOR.submit(() -> {
                PixelmonMusic.resetFade(sound, false);
                mcSoundManager.func_148611_c(sound);
                AtomicReference<Object> channel = new AtomicReference<Object>(null);
                PixelmonMusic.mcSoundManager.field_217942_m.forEach((s, c) -> {
                    if (Objects.equals(sound, s)) {
                        channel.set(c);
                    }
                });
                float initialVolume = 1.0f;
                if (channel.get() != null) {
                    initialVolume = mcSoundManager.func_188770_e(sound);
                }
                try {
                    int i = 0;
                    while ((long)i < millis) {
                        float volume = PixelmonMusic.fadeSound(sound, initialVolume, millis, false);
                        if (channel.get() != null) {
                            ((ChannelManager.Entry)channel.get()).func_217888_a(source -> source.func_216430_b(volume));
                        }
                        Thread.sleep(1L);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PixelmonMusic.resetFade(sound, false);
                if (channel.get() != null) {
                    float finalInitialVolume = initialVolume;
                    ((ChannelManager.Entry)channel.get()).func_217888_a(source -> source.func_216430_b(finalInitialVolume));
                }
            });
        }
        catch (Exception e) {
            mcSoundManager.func_148611_c(sound);
        }
    }

    public static void fadeSoundToStop(ISound sound, long millis) {
        if (mcSoundManager.func_217933_b(sound)) {
            PixelmonMusic.fadeSoundToStopInternal(sound, millis, null);
        }
    }

    public static void fadeSoundToStop(ISound sound, long millis, Runnable runnable) {
        if (mcSoundManager.func_217933_b(sound)) {
            PixelmonMusic.fadeSoundToStopInternal(sound, millis, runnable);
        } else {
            runnable.run();
        }
    }

    private static void fadeSoundToStopInternal(ISound sound, long millis, Runnable runnable) {
        block2: {
            try {
                EXECUTOR.submit(() -> {
                    PixelmonMusic.resetFade(sound, true);
                    AtomicReference<Object> channel = new AtomicReference<Object>(null);
                    PixelmonMusic.mcSoundManager.field_217942_m.forEach((s, c) -> {
                        if (Objects.equals(sound, s)) {
                            channel.set(c);
                        }
                    });
                    float initialVolume = 1.0f;
                    if (channel.get() != null) {
                        initialVolume = mcSoundManager.func_188770_e(sound);
                    }
                    try {
                        int i = 0;
                        while ((long)i < millis) {
                            float volume = PixelmonMusic.fadeSound(sound, initialVolume, millis, true);
                            if (channel.get() != null) {
                                ((ChannelManager.Entry)channel.get()).func_217888_a(source -> source.func_216430_b(volume));
                            }
                            Thread.sleep(1L);
                            ++i;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    mcSoundManager.func_148602_b(sound);
                    PixelmonMusic.resetFade(sound, true);
                    if (channel.get() != null) {
                        float finalInitialVolume = initialVolume;
                        ((ChannelManager.Entry)channel.get()).func_217888_a(source -> source.func_216430_b(finalInitialVolume));
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                });
            }
            catch (Exception e) {
                mcSoundManager.func_148602_b(sound);
                if (runnable == null) break block2;
                runnable.run();
            }
        }
    }

    public static void pause(ISound sound) {
        if (mcSoundManager.func_217933_b(sound)) {
            mcSoundHandler.func_147689_b();
        }
    }

    public static void resume(ISound sound) {
        mcSoundHandler.func_147682_a(sound);
    }

    public static float fadeSound(ISound sound, float initialVolume, long factor, boolean fadeOut) {
        float fade = FADE.getOrDefault(sound, Float.valueOf(fadeOut ? 1.0f : 0.0f)).floatValue();
        fade = fadeOut ? (fade -= 1.0f / (float)factor) : (fade += 1.0f / (float)factor);
        FADE.put(sound, Float.valueOf(fade));
        return initialVolume * fade;
    }

    public static void resetFade(ISound sound, boolean fadeOut) {
        FADE.put(sound, Float.valueOf(fadeOut ? 1.0f : 0.0f));
    }

    static {
        FADE = Maps.newConcurrentMap();
    }
}

