/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.SlotBase;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;

class DropDownSlot<T>
extends SlotBase {
    private DropDown<T> dropDown;
    private int dropDownWidth;

    public DropDownSlot(DropDown<T> dropDown, int top, int left, int width, int height) {
        super(top, left, width, height, true);
        this.dropDown = dropDown;
        this.dropDownWidth = width;
    }

    public DropDownSlot(DropDown<T> dropDown, int top, int left, int width, int height, int dropDownWidth) {
        super(top, left, width, height, true);
        this.dropDown = dropDown;
        this.dropDownWidth = dropDownWidth;
    }

    @Override
    protected int getSize() {
        return this.dropDown.options.size();
    }

    @Override
    protected void elementClicked(int index, boolean doubleClicked) {
        this.dropDown.elementClicked(index);
    }

    @Override
    protected boolean isSelected(int element) {
        return element == this.dropDown.selectedIndex;
    }

    @Override
    protected void drawSlot(MatrixStack matrix, int index, int x, int yTop, int yMiddle) {
        this.drawOptionString(matrix, index, yTop);
    }

    void drawOptionString(MatrixStack matrix, int index, int y) {
        if (index < 0 || index >= this.dropDown.options.size()) {
            return;
        }
        this.drawOptionString(matrix, this.dropDown.options.get(index), y);
    }

    void drawOptionString(MatrixStack matrix, T option, int y) {
        if (option == null) {
            return;
        }
        int width = this.dropDown.active ? this.dropDownWidth : this.field_230688_j_;
        String optionString = this.dropDown.toOptionString(option);
        String limitedString = ScreenHelper.getLimitedString(optionString, width);
        int color = 0;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.0, 1.0);
        switch (this.dropDown.align) {
            case Left: {
                ScreenHelper.drawSquashedString(matrix, Minecraft.func_71410_x().field_71466_p, optionString, true, (float)(width - 3), (float)(this.left + 2), (float)y, color, false);
                break;
            }
            case Center: {
                ScreenHelper.drawCenteredString(matrix, limitedString, (float)this.left + (float)width / 2.0f, (float)y, color);
                break;
            }
            case Right: {
                ScreenHelper.drawStringRightAligned(matrix, limitedString, this.left + width, y, color);
            }
        }
        matrix.func_227865_b_();
    }

    @Override
    protected void drawBackground(MatrixStack matrix) {
        this.drawBackgroundRect(matrix, this.top + 3, this.top + this.field_230689_k_, -5000269);
    }

    void drawBackgroundRect(MatrixStack matrix, int top, int bottom, int color) {
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.left, (int)top, (int)(this.left + (this.dropDown.active ? this.dropDownWidth : this.field_230688_j_)), (int)bottom, (int)color);
    }

    @Override
    protected float[] get1Color() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    @Override
    protected Color getSelectionColor() {
        return new Color(128, 128, 128);
    }

    @Override
    protected int[] get255Color() {
        return null;
    }

    @Override
    public int getCurrentSlot(int par1, int par2) {
        if (this.func_231047_b_(par1, par2)) {
            int var3 = this.left;
            int var4 = this.left + (this.dropDown.active ? this.dropDownWidth : this.field_230688_j_);
            int var5 = par2 - this.top + this.amountScrolled - 4;
            int var6 = var5 / this.slotHeight;
            return par1 >= var3 && par1 <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
        }
        return -1;
    }

    @Override
    public boolean func_231047_b_(double x, double y) {
        int right = (this.dropDown.active ? this.dropDownWidth : this.field_230688_j_) + this.left;
        return x > (double)this.left && x < (double)right && y > (double)this.top && y < (double)this.bottom;
    }

    @Override
    boolean inBoundsScroll(double x, double y) {
        int right = (this.dropDown.active ? this.dropDownWidth : this.field_230688_j_) + this.left;
        return x > (double)this.left && x < (double)(right + 6) && y > (double)this.top && y < (double)this.bottom;
    }

    @Override
    void drawSelection(MatrixStack matrix, int middleOfSelect, int topLeftOfSelect) {
        int leftish = this.left;
        int rightish = this.left + (this.dropDown.active ? this.dropDownWidth : this.field_230688_j_);
        matrix.func_227860_a_();
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)leftish, (int)(topLeftOfSelect + middleOfSelect + 1), (int)rightish, (int)topLeftOfSelect, (int)-1873784752);
        matrix.func_227865_b_();
    }

    @Override
    public boolean func_231044_a_(double mousePosX, double mousePosY, int button) {
        if (button != 0) {
            return false;
        }
        int width = this.dropDown.active ? this.dropDownWidth : this.field_230688_j_;
        int length = this.getSize();
        int posScrollBar = this.left + width;
        int posScrollBar2 = posScrollBar + 6;
        boolean flag = true;
        if (mousePosY >= (double)this.top && mousePosY <= (double)this.bottom) {
            int scrollPosX = this.right;
            int scrollPosY = (int)(mousePosY - (double)this.top + (double)this.amountScrolled - 4.0);
            int index = scrollPosY / this.slotHeight;
            if (this.func_231047_b_((int)mousePosX, (int)mousePosY) && index >= 0 && scrollPosY >= 0 && index < length) {
                boolean var12 = index == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                this.elementClicked(index, var12);
                this.selectedElement = index;
                this.lastClicked = System.currentTimeMillis();
            } else if (mousePosX >= (double)this.left && mousePosX <= (double)scrollPosX && scrollPosY < 0) {
                flag = false;
            }
            if (mousePosX >= (double)posScrollBar && mousePosX <= (double)posScrollBar2) {
                int middleOfSelect;
                this.scrollMultiplier = -1.0f;
                int topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4);
                if (topLeftOfSelect < 1) {
                    topLeftOfSelect = 1;
                }
                if ((middleOfSelect = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                    middleOfSelect = 32;
                }
                if (middleOfSelect > this.bottom - this.top - 8) {
                    middleOfSelect = this.bottom - this.top - 8;
                }
                this.scrollMultiplier /= (float)(this.bottom - this.top - middleOfSelect) / (float)topLeftOfSelect;
            } else {
                this.scrollMultiplier = 1.0f;
            }
            this.initialClickY = flag ? (float)mousePosY : -2.0f;
        } else {
            this.initialClickY = -2.0f;
        }
        this.bindAmountScrolled();
        return true;
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mousePosX, int mousePosY, float par3) {
        int middleOfSelect;
        int topLeftOfSelect;
        matrix.func_227860_a_();
        int width = this.dropDown.active ? this.dropDownWidth : this.field_230688_j_;
        int length = this.getSize();
        int posScrollBar = this.left + width;
        int posScrollBar2 = posScrollBar + 6;
        this.bindAmountScrolled();
        int scrollPosX = this.left;
        int scrollPosY = this.top + 2 - this.amountScrolled;
        this.drawBackground(matrix);
        for (int index = 0; index < length; ++index) {
            topLeftOfSelect = scrollPosY + index * this.slotHeight;
            middleOfSelect = this.slotHeight - 1;
            if (topLeftOfSelect + 6 > this.bottom || topLeftOfSelect + middleOfSelect - 8 < this.top) continue;
            if (this.isHighlighted(index, mousePosX, mousePosY)) {
                this.drawSelection(matrix, middleOfSelect, topLeftOfSelect);
            }
            this.drawSlot(matrix, index, scrollPosX, topLeftOfSelect, middleOfSelect);
        }
        topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4);
        if (topLeftOfSelect > 0) {
            int leftish;
            middleOfSelect = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (middleOfSelect < 32) {
                middleOfSelect = 32;
            }
            if (middleOfSelect > this.bottom - this.top - 8) {
                middleOfSelect = this.bottom - this.top - 8;
            }
            if ((leftish = this.amountScrolled * (this.bottom - this.top - middleOfSelect) / topLeftOfSelect + this.top) < this.top) {
                leftish = this.top;
            }
            ScreenHelper.drawQuad(matrix, posScrollBar, (float)this.bottom + 2.0f, 0.0f, posScrollBar2, (float)this.bottom + 2.0f, 0.0f, posScrollBar2, (float)this.top + 2.0f, 0.0f, posScrollBar, (float)this.top + 2.0f, 0.0f, COLOUR_BAR_ONE);
            ScreenHelper.drawQuad(matrix, posScrollBar, leftish + middleOfSelect + 2, 0.0f, posScrollBar2, leftish + middleOfSelect + 2, 0.0f, posScrollBar2, (float)leftish + 2.0f, 0.0f, posScrollBar, (float)leftish + 2.0f, 0.0f, COLOUR_BAR_TWO);
            ScreenHelper.drawQuad(matrix, posScrollBar, leftish + middleOfSelect - 1 + 2, 0.0f, posScrollBar2 - 1, leftish + middleOfSelect - 1 + 2, 0.0f, posScrollBar2 - 1, (float)leftish + 2.0f, 0.0f, posScrollBar, (float)leftish + 2.0f, 0.0f, COLOUR_BAR_THREE);
        }
        matrix.func_227865_b_();
    }
}

