/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.fishingLog;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.opengl.GL11;

public class FishingLogMenuScreen
extends Screen {
    private int centerX;
    private int centerY;
    private float guiHeight;
    private float guiWidth;
    private int currentScroll = 0;
    private int waitingScroll = 0;
    int maxScroll;
    private BiMap<Species, IndexedButton> buttons = HashBiMap.create();
    HashMap<Integer, int[]> map = new HashMap();
    HashMap<Integer, Double> percent = new HashMap();

    public FishingLogMenuScreen(int[] data) {
        super(StringTextComponent.field_240750_d_);
        int currentSpecies = -1;
        int total = -1;
        int count = 0;
        int[] arr = new int[]{};
        double seen = 0.0;
        for (int i = 1; i < data.length; ++i) {
            if (currentSpecies == -1) {
                currentSpecies = data[i];
            } else if (total == -1) {
                total = data[i];
                arr = new int[data[i]];
            } else {
                if (data[i] > 0) {
                    seen += 1.0;
                }
                arr[count] = data[i];
                ++count;
            }
            if (count != total) continue;
            this.percent.put(currentSpecies, seen * 100.0 / (double)total);
            seen = 0.0;
            this.map.put(currentSpecies, arr);
            currentSpecies = -1;
            total = -1;
            count = 0;
        }
        this.maxScroll = 240 * (this.map.values().size() / 3);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2;
        this.guiHeight = 220.0f;
        this.guiWidth = this.guiHeight * 0.698571f;
        this.map.forEach((id, data) -> {
            Species species = PixelmonSpecies.fromNationalDex(id);
            this.buttons.put((Object)species, (Object)this.func_230480_a_((Widget)new IndexedButton(species.getDex(), 0, 0, 60, 46, (ITextComponent)new StringTextComponent(species.toString()), this::actionPerformed)));
        });
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        this.processScroll();
        matrix.func_227860_a_();
        float sf = (float)this.field_230706_i_.func_228018_at_().func_198100_s();
        float x1 = ((float)this.centerX - this.guiWidth / 2.0f) * sf;
        float x2 = ((float)this.centerX + this.guiWidth / 2.0f) * sf;
        float y1 = ((float)this.centerY - this.guiHeight / 2.0f + 5.0f) * sf;
        float y2 = ((float)this.centerY + this.guiHeight / 2.0f - 5.0f) * sf;
        GL11.glScissor((int)((int)x1), (int)((int)((float)this.field_230706_i_.func_228018_at_().func_198083_n() - y2)), (int)((int)(x2 - x1)), (int)((int)(y2 - y1)));
        GL11.glEnable((int)3089);
        this.drawScreenForeground(matrix, mouseX, mouseY);
        GL11.glDisable((int)3089);
        matrix.func_227865_b_();
        int height = 15;
        float width = (float)height * 6.168067f;
        ScreenHelper.drawImageQuad(Resources.fishingLogTitle, matrix, (float)this.centerX - width / 2.0f, this.centerY - 117, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawScaledCenteredString(matrix, I18n.func_135052_a((String)"gui.fishinglog.menu.title", (Object[])new Object[0]), this.centerX, (float)this.centerY - 112.5f, -7781367, 14.0f);
    }

    private void drawScreenForeground(MatrixStack matrix, int mouseX, int mouseY) {
        float x = (float)this.centerX - this.guiWidth / 2.0f + 14.5f;
        AtomicInteger top = new AtomicInteger((int)((float)(this.currentScroll + this.centerY) - this.guiHeight / 2.0f + 20.0f));
        DecimalFormat format = new DecimalFormat("###.#");
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = 0;
        for (IndexedButton button : this.buttons.values()) {
            Species form = (Species)this.buttons.inverse().get((Object)button);
            float height = 45.6f;
            float xPos = x + 63.5f * (float)(i % 2);
            ScreenHelper.drawImageQuad(Resources.fishingMenuContainer, matrix, xPos, top.get(), 60.0f, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            button.field_230690_l_ = (int)xPos;
            button.field_230691_m_ = top.get();
            if (this.percent.get(form.getDex()) == 0.0) {
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            }
            ScreenHelper.drawImageQuad(form.getFirstPaletteProperties().getSprite(), matrix, xPos + 10.0f, top.get() - 1, 39.0f, 39.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            ScreenHelper.drawScaledString(matrix, format.format(this.percent.get(form.getDex())) + "%", xPos + 3.0f, top.get() + 3, -1, 8.0f);
            ScreenHelper.drawScaledCenteredSplitString(matrix, this.percent.get(form.getDex()) == 0.0 ? "???" : form.getLocalizedName(), xPos + 30.0f, (float)top.get() + height + 4.0f, -7845363, 10.0f, 50, false);
            if (++i % 2 != 0) continue;
            top.addAndGet(65);
        }
    }

    public void func_230446_a_(MatrixStack matrix) {
        ScreenHelper.drawImageQuad(Resources.fishingLogBackground, matrix, (float)this.centerX - this.guiWidth / 2.0f, (float)this.centerY - this.guiHeight / 2.0f, this.guiWidth, this.guiHeight, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void processScroll() {
        int mustard = 6;
        if (this.waitingScroll != 0) {
            if (Math.abs(this.waitingScroll) >= mustard) {
                if (this.waitingScroll < 0) {
                    this.waitingScroll += mustard;
                    this.currentScroll -= mustard;
                } else {
                    this.waitingScroll -= mustard;
                    this.currentScroll += mustard;
                }
            } else if (this.waitingScroll < 0) {
                ++this.waitingScroll;
                --this.currentScroll;
            } else {
                --this.waitingScroll;
                ++this.currentScroll;
            }
        }
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double i) {
        int speed = 20;
        if (i < 0.0) {
            this.waitingScroll += speed;
            if (this.currentScroll + this.waitingScroll > this.maxScroll - 240) {
                this.waitingScroll = this.maxScroll - 240 - this.currentScroll;
            }
        } else if (i > 0.0) {
            this.waitingScroll -= speed;
            if (this.currentScroll + this.waitingScroll < 0) {
                this.waitingScroll = -this.currentScroll;
            }
        }
        return super.func_231043_a_(p_231043_1_, p_231043_3_, i);
    }

    public void actionPerformed(Button button) {
        Species form;
        if (button instanceof IndexedButton && this.map.get((form = (Species)this.buttons.inverse().get((Object)button)).getDex()).length != 0) {
            Minecraft.func_71410_x().func_147108_a((Screen)new FishingLogScreen(form.getDex(), this.map.get(form.getDex())));
        }
    }
}

