/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.egg;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.MutablePair;

public class EggHatchingScreen
extends Screen {
    private static final ITextComponent ANIMATION_COMPLETE = new TranslationTextComponent("animation.complete");
    private static final ITextComponent STEP_ONE = new TranslationTextComponent("pixelmon.egg.step1");
    private static final ITextComponent STEP_TWO = new TranslationTextComponent("pixelmon.egg.step2");
    private static final ITextComponent STEP_THREE = new TranslationTextComponent("pixelmon.egg.step3");
    protected final int slot;
    protected float lastAngleX;
    protected float lastAngleZ;
    protected float lastScale;
    protected int ticks;
    protected boolean complete = false;
    protected SimpleSound sound = null;
    protected SimpleSound firstSound = null;
    protected SimpleSound pokemonSound = null;
    protected Button button;
    protected List<MutablePair<Vector2f, Vector2f>> particles = Lists.newArrayList();

    public EggHatchingScreen(int slot) {
        super(StringTextComponent.field_240750_d_);
        this.slot = slot;
    }

    protected void func_231160_c_() {
        this.ticks = 0;
        this.lastAngleX = 0.0f;
        this.lastAngleZ = 0.0f;
        this.lastScale = 1.0f;
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
        Minecraft.func_71410_x().field_71474_y.field_74343_n = ChatVisibility.HIDDEN;
        this.button = new Button(this.field_230708_k_ / 2 - 40, this.field_230709_l_ - 20, 80, 20, (ITextComponent)new TranslationTextComponent(this.complete ? "animation.complete" : "animation.skip"), button -> this.func_231175_as__());
        this.func_230480_a_((Widget)this.button);
        this.particles.clear();
    }

    public void func_231023_e_() {
        ++this.ticks;
        for (MutablePair<Vector2f, Vector2f> particle : this.particles) {
            particle.setLeft((Object)new Vector2f(((Vector2f)particle.getLeft()).field_189982_i + ((Vector2f)particle.getRight()).field_189982_i, ((Vector2f)particle.getLeft()).field_189983_j + ((Vector2f)particle.getRight()).field_189983_j));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        SoundEvent cry;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(QuaternionHelper.fromEuler(partialTicks > 50.0f ? 20.0f : -20.0f, 0.0f, 0.0f, 0.0f));
        RenderSystem.enableColorMaterial();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        int loop = this.ticks % 301;
        Pokemon pokemon = ClientStorageManager.party.get(this.slot);
        ResourceLocation egg = Resources.getEggSprite(pokemon.getSpecies(), 11);
        if (this.firstSound == null) {
            this.firstSound = SimpleSound.func_184371_a((SoundEvent)((SoundEvent)SoundRegistration.EGG_HYPE.get()), (float)1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.firstSound);
        }
        if (loop < 5) {
            this.lastScale = 1.0f;
            this.lastAngleZ = 0.0f;
            this.lastAngleX -= 1.0f;
        } else if (loop < 10) {
            this.lastAngleX += 1.0f;
        } else if (loop < 15) {
            this.lastAngleX -= 2.0f;
        } else if (loop < 20) {
            this.lastAngleX += 2.0f;
        } else if (loop < 25) {
            this.lastAngleX -= 1.0f;
        } else if (loop < 30) {
            this.lastAngleX += 1.0f;
        } else if (loop < 35) {
            this.lastAngleX = 0.0f;
            this.lastAngleZ += 1.125f;
        } else if (loop < 45) {
            this.lastAngleZ -= 1.125f;
        } else if (loop < 55) {
            this.lastAngleZ += 1.125f;
        } else if (loop < 65) {
            this.lastAngleZ -= 1.125f;
        } else if (loop < 75) {
            this.lastAngleZ += 1.125f;
        } else if (loop < 85) {
            this.lastAngleZ -= 1.125f;
        } else if (loop < 90) {
            this.lastAngleZ += 1.125f;
        } else if (loop >= 120) {
            if (loop < 122) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 126) {
                this.lastAngleZ -= 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 128) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 150) {
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 152) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 156) {
                this.lastAngleZ -= 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 158) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 170) {
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 301) {
                this.lastAngleZ = 0.0f;
                this.lastAngleX = 0.0f;
                this.complete = true;
                this.button.func_238482_a_(ANIMATION_COMPLETE);
                egg = ClientStorageManager.party.get(this.slot).getSprite();
            }
        }
        if (loop > 160 && loop < 295 && this.sound == null) {
            this.sound = SimpleSound.func_184371_a((SoundEvent)((SoundEvent)SoundRegistration.EGG_REVEAL.get()), (float)1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
        }
        if (loop > 190 && loop < 295 && this.pokemonSound == null && (cry = pokemon.getPalette().getSound()) != null) {
            this.pokemonSound = SimpleSound.func_184371_a((SoundEvent)cry, (float)1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.pokemonSound);
        }
        if (loop > 170) {
            if (loop % 5 == 0) {
                double angle = Math.random() * 2.0 * Math.PI;
                Vector2f vector2f = new Vector2f((float)Math.cos(angle) * 3.0f, (float)Math.sin(angle) * 3.0f);
                this.particles.add((MutablePair<Vector2f, Vector2f>)new MutablePair((Object)new Vector2f((float)this.field_230708_k_ / 2.0f, 0.75f * (float)this.field_230709_l_), (Object)vector2f));
            }
            if (loop < 175) {
                this.lastScale = (float)((double)this.lastScale + 0.01);
            } else if (loop < 180) {
                this.lastScale = (float)((double)this.lastScale - 0.01);
            } else if (loop < 185) {
                this.lastScale = (float)((double)this.lastScale + 0.01);
            } else if (loop < 190) {
                this.lastScale = (float)((double)this.lastScale - 0.01);
            }
        }
        Object component = loop < 30 ? STEP_ONE : (loop < 120 ? STEP_TWO : (loop < 170 ? STEP_THREE : new TranslationTextComponent("pixelmon.egg.step4", new Object[]{pokemon.getDisplayName()})));
        boolean shinyStar = pokemon.isLegendary() || pokemon.isShiny() || pokemon.isUltraBeast();
        for (MutablePair<Vector2f, Vector2f> particle : this.particles) {
            ScreenHelper.drawImage(matrixStack, Resources.shiny, ((Vector2f)particle.left).field_189982_i, ((Vector2f)particle.left).field_189983_j, 16.0f, 16.0f, shinyStar ? 1.0f : 0.5f, shinyStar ? 1.0f : 0.5f, shinyStar ? 1.0f : 0.5f, shinyStar ? 1.0f : 0.5f, 2.0f);
        }
        ScreenHelper.drawImage(matrixStack, ResourceLocationHelper.of("pixelmon", "textures/gui/egg/egg_shadow.png"), (float)this.field_230708_k_ / 2.0f - 48.0f, (float)this.field_230709_l_ * 0.77f - 48.0f, 96.0f, 96.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawImage(matrixStack, ResourceLocationHelper.of("pixelmon", "textures/gui/egg/background.png"), (float)this.field_230708_k_ / 2.0f - 128.0f, (float)this.field_230709_l_ * 0.15f - 12.0f, 256.0f, 32.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.field_230712_o_.func_243248_b(matrixStack, component, (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)component) / 2.0f, (float)this.field_230709_l_ * 0.15f, 2);
        matrixStack.func_227860_a_();
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(this.lastAngleZ);
        matrixStack.func_227861_a_((double)this.field_230708_k_ / 2.0, (double)(0.75f * (float)this.field_230709_l_ + this.lastAngleX), 0.0);
        matrixStack.func_227863_a_(quaternion);
        matrixStack.func_227862_a_(this.lastScale, this.lastScale, 0.0f);
        ScreenHelper.drawImageQuad(egg, matrixStack, -64.0f, -96.0f, 128.0f, 128.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231175_as__() {
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
        Minecraft.func_71410_x().field_71474_y.field_74343_n = ChatVisibility.FULL;
        this.endActiveSound(this.sound);
        this.endActiveSound(this.firstSound);
        this.endActiveSound(this.pokemonSound);
        super.func_231175_as__();
    }

    public void endActiveSound(SimpleSound playing) {
        if (Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)playing)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)playing);
        }
    }
}

