/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.GraphicsConfig;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.toast.ExpandingTutorialToast;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.animations.particles.ParticleGastly;
import com.pixelmonmod.pixelmon.client.DefaultServerList;
import com.pixelmonmod.pixelmon.client.PixelmonDownloadingPackFinder;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.gui.CameraOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.CharmScreen;
import com.pixelmonmod.pixelmon.client.gui.ChatOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.DoctorScreen;
import com.pixelmonmod.pixelmon.client.gui.HealerScreen;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.MegaItemScreen;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.SelectStatScreen;
import com.pixelmonmod.pixelmon.client.gui.TradingScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.BattleRulesFixedScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.BattleRulesPlayerScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.TeamSelectScreen;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ChooseMovesetScreen;
import com.pixelmonmod.pixelmon.client.gui.curryDex.CurryDexScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.InputScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.dialogue.DialogueScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomNoticeOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomScoreboardOverlay;
import com.pixelmonmod.pixelmon.client.gui.egg.EggHatchingScreen;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogInformationScreen;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogMenuScreen;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogScreen;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryDetectionTickHandler;
import com.pixelmonmod.pixelmon.client.gui.inventory.SearchTreeExtender;
import com.pixelmonmod.pixelmon.client.gui.mail.MailScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ChattingNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.NPCTraderScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.QuestGiverNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.RelearnerScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.SelectPartyPokemonScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ShopkeeperScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.TutorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ChattingNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ConfirmDeleteNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.CreateNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.QuestGiverNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ShopkeeperEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TradeEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TutorEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.pc.PCScreen;
import com.pixelmonmod.pixelmon.client.gui.pokedex.PokedexScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.EditedPlayerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.client.gui.selectMove.SelectMoveScreen;
import com.pixelmonmod.pixelmon.client.gui.spawner.PixelmonSpawnerScreen;
import com.pixelmonmod.pixelmon.client.gui.starter.ChooseStarterScreen;
import com.pixelmonmod.pixelmon.client.gui.statueEditor.StatueEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.vendingmachine.VendingMachineScreen;
import com.pixelmonmod.pixelmon.client.gui.zygarde.ZygardeCubeScreen;
import com.pixelmonmod.pixelmon.client.gui.zygarde.ZygardeReassemblyUnitScreen;
import com.pixelmonmod.pixelmon.client.keybindings.ActionKey;
import com.pixelmonmod.pixelmon.client.keybindings.ChooseMoveSkillKey;
import com.pixelmonmod.pixelmon.client.keybindings.DebugKeyBindings;
import com.pixelmonmod.pixelmon.client.keybindings.DescendKey;
import com.pixelmonmod.pixelmon.client.keybindings.HoverKey;
import com.pixelmonmod.pixelmon.client.keybindings.MinimizeMaximizeOverlayKey;
import com.pixelmonmod.pixelmon.client.keybindings.NextPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.OldMovementHandler;
import com.pixelmonmod.pixelmon.client.keybindings.OptionsKey;
import com.pixelmonmod.pixelmon.client.keybindings.PokedexKey;
import com.pixelmonmod.pixelmon.client.keybindings.PreviousPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.QuestCycleKey;
import com.pixelmonmod.pixelmon.client.keybindings.QuestJournalKey;
import com.pixelmonmod.pixelmon.client.keybindings.SendPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.SpectateKey;
import com.pixelmonmod.pixelmon.client.keybindings.TrainerCardKey;
import com.pixelmonmod.pixelmon.client.keybindings.UseMoveSkillKey;
import com.pixelmonmod.pixelmon.client.keybindings.WikiKey;
import com.pixelmonmod.pixelmon.client.listener.MouseOverPlayer;
import com.pixelmonmod.pixelmon.client.listener.WallpapersListener;
import com.pixelmonmod.pixelmon.client.models.ResourceLoader;
import com.pixelmonmod.pixelmon.client.music.PixelmonMusic;
import com.pixelmonmod.pixelmon.client.particle.ParticleEvents;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockRevealRenderer;
import com.pixelmonmod.pixelmon.client.render.custom.RenderPixelmonPainting;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.BikeRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.ChairMountRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.DenRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.HookRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.InvisibleCameraRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.NPCRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonBoatRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PokeBallRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.StatueRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.WormholeRenderer;
import com.pixelmonmod.pixelmon.client.render.layers.LayerCharms;
import com.pixelmonmod.pixelmon.client.render.layers.LayerEquippables;
import com.pixelmonmod.pixelmon.client.render.layers.LayerMegaItems;
import com.pixelmonmod.pixelmon.client.render.layers.LayerSash;
import com.pixelmonmod.pixelmon.client.render.layers.LayerWings;
import com.pixelmonmod.pixelmon.client.render.layers.PixelmonLayerHead;
import com.pixelmonmod.pixelmon.client.render.layers.PixelmonLayerRobe;
import com.pixelmonmod.pixelmon.client.render.player.PixelRenderPlayer;
import com.pixelmonmod.pixelmon.client.render.player.RenderEvents;
import com.pixelmonmod.pixelmon.client.richpresence.PixelmonRichPresence;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.EnumBreedingParticles;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumPixelmonParticles;
import com.pixelmonmod.pixelmon.enums.items.EnumCharms;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ItemFinderItem;
import com.pixelmonmod.pixelmon.items.TechnicalMoveItem;
import com.pixelmonmod.pixelmon.listener.BackgroundMusicListener;
import com.pixelmonmod.pixelmon.listener.ClientNetworkListener;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorScreen;
import com.pixelmonmod.pixelmon.quests.client.rendering.QuestMarkerRenderer;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.world.dimension.client.ClientDimensionRegistration;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import com.pixelmonmod.pixelmon.world.listener.DrownedWorldClientListener;
import com.pixelmonmod.pixelmon.world.listener.UltraSpaceClientListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.WoodType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.TutorialToast;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    public static final SendPokemonKey SEND_POKEMON_KEY = new SendPokemonKey();
    public static final int defaultTexUnit = 33984;
    public static final int lightmapTexUnit = 33985;
    public static ClientBattleManager battleManager = new ClientBattleManager();
    public static ArrayList<MoveSkill> moveSkills = new ArrayList();
    public static TradePair currentTradePair = null;
    public static boolean playerHasTradeRequestPokemon = false;
    public static CameraEntity camera;
    private static PixelmonRichPresence richPresence;
    private static ExpandingTutorialToast toast;
    public static ActionKey actionKeyBind;
    public static UseMoveSkillKey useMoveSkillKeyBind;
    public static ChooseMoveSkillKey chooseMoveSkillKey;
    public static PokedexKey pokedexKeyBind;
    public static TrainerCardKey trainerCardKeyBind;
    public static WikiKey wikiKeyBind;
    public static SpectateKey spectateKeyBind;
    public static QuestJournalKey questJournalKeyBind;
    public static QuestCycleKey questCycleKeyBind;
    public static KeyBinding pcSearchKeyBind;
    public static KeyBinding pcRenameKeyBind;
    public static KeyBinding pcWallpaperKeyBind;
    static ConcurrentHashMap<String, ResourceLocation> cachedSkins;
    static List<String> invaildSkins;

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        try {
            Minecraft minecraft = (Minecraft)event.getMinecraftSupplier().get();
            InputStream inputstream = minecraft.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("pixelmon", "textures/icon_16x16.png"));
            InputStream inputstream1 = minecraft.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("pixelmon", "textures/icon_32x32.png"));
            ((Minecraft)event.getMinecraftSupplier().get()).func_228018_at_().func_216529_a(inputstream, inputstream1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClientProxy.registerKeyBindings();
        ClientProxy.addPokemonRenderers();
        DimensionRenderInfo.field_239208_a_.put((Object)ResourceLocationHelper.of("pixelmon:ultra_space"), (Object)new UltraSpace.UltraSpaceRenderInfo());
        DimensionRenderInfo.field_239208_a_.put((Object)ResourceLocationHelper.of("pixelmon:drowned_world"), (Object)new DrownedWorld.DrownedWorldRenderInfo());
        ClientDimensionRegistration.register(event);
        MinecraftForge.EVENT_BUS.register((Object)new ParticleEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ClientProxy());
        MinecraftForge.EVENT_BUS.register(CameraOverlayScreen.class);
        MinecraftForge.EVENT_BUS.register(ClientNetworkListener.class);
        Pixelmon.EVENT_BUS.register(BackgroundMusicListener.class);
        PlayerExtraDataStore.loadClientData();
        ResourceLocation mt = ResourceLocationHelper.of("pixelmon", "move_type");
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen1, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen2, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen3, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen4, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen5, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen6, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen7, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen8, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tr_gen8, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.tm_gen9, (ResourceLocation)mt, (IItemPropertyGetter)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemModelsProperties.func_239418_a_((Item)PixelmonItems.item_finder, (ResourceLocation)new ResourceLocation("pixelmon", "direction"), (IItemPropertyGetter)ItemFinderItem.PropertyGetter.INSTANCE);
        ItemRegistration.registerItemLayers();
        ClientProxy.registerRenderers();
        ClientProxy.registerTickHandlers();
        Minecraft mc = Minecraft.func_71410_x();
        DownloadingPackFinder dpf = Minecraft.func_71410_x().func_195541_I();
        ResourceIndex ri = (ResourceIndex)ObfuscationReflectionHelper.getPrivateValue(DownloadingPackFinder.class, (Object)dpf, (String)"field_217819_f");
        Object old = ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)mc, (String)"field_195554_ax");
        PixelmonDownloadingPackFinder download = new PixelmonDownloadingPackFinder(new File(mc.field_71412_D, "server-resource-packs"), ri);
        ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)mc, (Object)((Object)download), (String)"field_195554_ax");
        ResourcePackList packList = (ResourcePackList)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)mc, (String)"field_110448_aq");
        Set packFinders = (Set)ObfuscationReflectionHelper.getPrivateValue(ResourcePackList.class, (Object)packList, (String)"field_198987_a");
        packFinders.removeIf(iPackFinder -> Objects.equals(iPackFinder, old));
        packFinders.add(download);
        DefaultServerList.tryFetchDefaultServers();
        richPresence = new PixelmonRichPresence("696343075731144724");
        Atlases.field_228750_i_.put(PixelmonWoodType.ULTRA_JUNGLE_WOOD, Atlases.func_228773_a_((WoodType)PixelmonWoodType.ULTRA_JUNGLE_WOOD));
        Atlases.field_228750_i_.put(PixelmonWoodType.ULTRA_ELM_WOOD, Atlases.func_228773_a_((WoodType)PixelmonWoodType.ULTRA_ELM_WOOD));
        Atlases.field_228750_i_.put(PixelmonWoodType.ULTRA_GINGKO_WOOD, Atlases.func_228773_a_((WoodType)PixelmonWoodType.ULTRA_GINGKO_WOOD));
        HashSet registeredColors = Sets.newHashSet();
        for (BerryType berry : BerryType.values()) {
            if (registeredColors.contains(berry.color)) continue;
            registeredColors.add(berry.color);
            Atlases.field_228750_i_.put(berry.getWoodType(), Atlases.func_228773_a_((WoodType)berry.getWoodType()));
        }
    }

    public static void registerRenderers() {
        TileEntityRegistration.bindRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new CustomOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new PixelmonOverlayScreen());
        MinecraftForge.EVENT_BUS.register((Object)new ChatOverlayScreen(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new MouseOverPlayer());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockRevealRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new QuestMarkerRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new DrownedWorldClientListener());
        MinecraftForge.EVENT_BUS.register((Object)new UltraSpaceClientListener());
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        PlayerRenderer aDefault = (PlayerRenderer)renderManager.field_178636_l.remove("default");
        PlayerRenderer slim = (PlayerRenderer)renderManager.field_178636_l.remove("slim");
        renderManager.field_178636_l.put("default", new PixelRenderPlayer(renderManager));
        renderManager.field_178636_l.put("slim", new PixelRenderPlayer(renderManager, true));
        PlayerRenderer rp = (PlayerRenderer)renderManager.field_178636_l.get("default");
        List layers = aDefault.field_177097_h;
        layers.removeIf(layer -> layer instanceof BipedArmorLayer || layer instanceof HeldItemLayer);
        rp.func_177094_a((LayerRenderer)new PixelmonLayerHead(rp));
        rp.func_177094_a((LayerRenderer)new LayerSash(rp));
        rp.func_177094_a((LayerRenderer)new PixelmonLayerRobe(rp));
        rp.func_177094_a((LayerRenderer)new LayerMegaItems(rp));
        rp.func_177094_a((LayerRenderer)new LayerCharms(rp));
        rp.func_177094_a((LayerRenderer)new LayerEquippables(rp));
        rp.func_177094_a((LayerRenderer)new LayerWings(rp));
        rp = (PlayerRenderer)renderManager.field_178636_l.get("slim");
        layers = slim.field_177097_h;
        layers.removeIf(layer -> layer instanceof BipedArmorLayer || layer instanceof HeldItemLayer);
        rp.func_177094_a((LayerRenderer)new PixelmonLayerHead(rp));
        rp.func_177094_a((LayerRenderer)new LayerSash(rp));
        rp.func_177094_a((LayerRenderer)new PixelmonLayerRobe(rp));
        rp.func_177094_a((LayerRenderer)new LayerMegaItems(rp));
        rp.func_177094_a((LayerRenderer)new LayerCharms(rp));
        rp.func_177094_a((LayerRenderer)new LayerEquippables(rp));
        rp.func_177094_a((LayerRenderer)new LayerWings(rp));
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        ItemRegistration.bakeModels(event);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)LayerWings.WINGS_MODEL);
        ModelLoader.addSpecialModel((ResourceLocation)LayerWings.VALENTINES_WINGS_MODEL);
        ModelLoader.addSpecialModel((ResourceLocation)PixelmonLayerHead.WITCH_HAT_MODEL);
    }

    @SubscribeEvent
    public static void onColourBlockEvent(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_WALL.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_BUTTON.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_SLAB.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_PRESSURE_PLATE.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_STAIRS.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_SLAB.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_STAIRS.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_WALL.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_BUTTON.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_PRESSURE_PLATE.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.CHISELED_ULTRA_SPACE_STONE.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE_SLAB.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE_STAIRS.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE_WALL.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> 5886463, new Block[]{(Block)BlockRegistration.COMMON_POKESTOP.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> 5305214, new Block[]{(Block)BlockRegistration.RARE_POKESTOP.get()});
        event.getBlockColors().func_186722_a((state, reader, pos, something) -> 11230451, new Block[]{(Block)BlockRegistration.LEGENDARY_POKESTOP.get()});
    }

    @SubscribeEvent
    public static void stitcherEventPre(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().func_110623_a().toString().equals(AtlasTexture.field_110575_b.func_110623_a())) {
            return;
        }
        event.addSprite(ResourceLocationHelper.of("pixelmon:items/back"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:items/front"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:items/unoorb"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:items/dosorb"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:items/tresorb"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:items/tresorb"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:sprites/eggs/egg1"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:sprites/eggs/egg2"));
        event.addSprite(ResourceLocationHelper.of("pixelmon:sprites/eggs/egg3"));
        ClientProxy.bakeSprites(event);
    }

    private static void bakeSprites(TextureStitchEvent.Pre event) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        Collection sprites = resourceManager.func_199003_a("textures/pokemon", s -> s.endsWith("sprite.png"));
        for (ResourceLocation pngPath : sprites) {
            event.addSprite(ResourceLocationHelper.of(pngPath.func_110624_b(), pngPath.func_110623_a().replace("textures/", "").replace(".png", "")));
        }
        Collection balls = resourceManager.func_199003_a("textures/items/pokeballs", s -> s.endsWith(".png"));
        for (ResourceLocation pngPath : balls) {
            event.addSprite(ResourceLocationHelper.of(pngPath.func_110624_b(), pngPath.func_110623_a().replace("textures/", "").replace(".png", "")));
        }
    }

    public static void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)SEND_POKEMON_KEY);
        MinecraftForge.EVENT_BUS.register((Object)SEND_POKEMON_KEY);
        NextPokemonKey k2 = new NextPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k2);
        MinecraftForge.EVENT_BUS.register((Object)k2);
        DebugKeyBindings debugKeyBindings = new DebugKeyBindings();
        MinecraftForge.EVENT_BUS.register((Object)debugKeyBindings);
        PreviousPokemonKey k3 = new PreviousPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k3);
        MinecraftForge.EVENT_BUS.register((Object)k3);
        MinimizeMaximizeOverlayKey k4 = new MinimizeMaximizeOverlayKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k4);
        MinecraftForge.EVENT_BUS.register((Object)k4);
        DescendKey k5 = new DescendKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k5);
        MinecraftForge.EVENT_BUS.register((Object)k5);
        HoverKey k6 = new HoverKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k6);
        MinecraftForge.EVENT_BUS.register((Object)k6);
        spectateKeyBind = new SpectateKey();
        ClientRegistry.registerKeyBinding((KeyBinding)spectateKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)spectateKeyBind);
        questJournalKeyBind = new QuestJournalKey();
        ClientRegistry.registerKeyBinding((KeyBinding)questJournalKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)questJournalKeyBind);
        questCycleKeyBind = new QuestCycleKey();
        ClientRegistry.registerKeyBinding((KeyBinding)questCycleKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)questCycleKeyBind);
        actionKeyBind = new ActionKey();
        ClientRegistry.registerKeyBinding((KeyBinding)actionKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)actionKeyBind);
        useMoveSkillKeyBind = new UseMoveSkillKey();
        ClientRegistry.registerKeyBinding((KeyBinding)useMoveSkillKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)useMoveSkillKeyBind);
        chooseMoveSkillKey = new ChooseMoveSkillKey();
        ClientRegistry.registerKeyBinding((KeyBinding)chooseMoveSkillKey);
        MinecraftForge.EVENT_BUS.register((Object)chooseMoveSkillKey);
        pokedexKeyBind = new PokedexKey();
        ClientRegistry.registerKeyBinding((KeyBinding)pokedexKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)pokedexKeyBind);
        trainerCardKeyBind = new TrainerCardKey();
        ClientRegistry.registerKeyBinding((KeyBinding)trainerCardKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)trainerCardKeyBind);
        wikiKeyBind = new WikiKey();
        ClientRegistry.registerKeyBinding((KeyBinding)wikiKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)wikiKeyBind);
        pcSearchKeyBind = new KeyBinding("key.pcsearch", 83, "key.categories.pixelmon");
        ClientRegistry.registerKeyBinding((KeyBinding)pcSearchKeyBind);
        pcRenameKeyBind = new KeyBinding("key.pcrename", 82, "key.categories.pixelmon");
        ClientRegistry.registerKeyBinding((KeyBinding)pcRenameKeyBind);
        pcWallpaperKeyBind = new KeyBinding("key.pcwallpaper", 87, "key.categories.pixelmon");
        ClientRegistry.registerKeyBinding((KeyBinding)pcWallpaperKeyBind);
        MinecraftForge.EVENT_BUS.register(OldMovementHandler.class);
        OptionsKey k7 = new OptionsKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k7);
        MinecraftForge.EVENT_BUS.register((Object)k7);
        PixelmonMusic.init(Minecraft.func_71410_x());
    }

    private static void addPokemonRenderers() {
        IRenderFactory npcFactory = NPCRenderer::new;
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.EMPTY_POKEBALL.get()), PokeBallRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.OCCUPIED_POKEBALL.get()), PokeBallRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.HOOK.get()), HookRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_TRAINER.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_CHATTING.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_QUEST_GIVER.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_TRADER.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_RELEARNER.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_TUTOR.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_NURSE_JOY.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_FISHERMAN.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.NPC_SHOPKEEPER.get()), (IRenderFactory)npcFactory);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.STATUE.get()), StatueRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.PIXELMON.get()), PixelmonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.CAMERA.get()), InvisibleCameraRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.WORMHOLE.get()), WormholeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.BIKE.get()), BikeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.PAINTING.get()), RenderPixelmonPainting::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.DEN.get()), DenRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.CHAIR_MOUNT.get()), ChairMountRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.BOAT.get()), PixelmonBoatRenderer::new);
    }

    public static Screen createScreen(PlayerEntity player, EnumGuiScreen gui, int[] data) {
        switch (gui) {
            case ChooseStarter: {
                return new ChooseStarterScreen();
            }
            case Dialogue: {
                return new DialogueScreen();
            }
            case Healer: {
                return new HealerScreen();
            }
            case Pokedex: {
                return new PokedexScreen(data[0]);
            }
            case PickPokemon: {
                return new SelectPartyPokemonScreen(data[0], data[1]);
            }
            case PC: {
                return new PCScreen();
            }
            case ChooseRelearnMove: 
            case ChooseTutor: 
            case Battle: {
                return new BattleScreen();
            }
            case Trading: {
                return new TradingScreen(data[0], data[1], data[2]);
            }
            case Doctor: {
                return new DoctorScreen();
            }
            case ItemDrops: {
                return new ItemDropsScreen();
            }
            case PixelmonSpawner: {
                return new PixelmonSpawnerScreen(data[0], data[1], data[2]);
            }
            case TrainerEditor: {
                return new TrainerEditorScreen(data[0]);
            }
            case ChooseMoveset: {
                return new ChooseMovesetScreen(ClientStorageManager.party.get(data[0]));
            }
            case NPCTrade: {
                return new TradeEditorScreen(data[0]);
            }
            case NPCTraderGui: {
                return new NPCTraderScreen(data[0]);
            }
            case StatueEditor: {
                return new StatueEditorScreen(data[0]);
            }
            case InputScreen: {
                return new InputScreen();
            }
            case CreateNpc: {
                return new CreateNPCScreen(new BlockPos(data[0], data[1], data[2]));
            }
            case DeleteNpc: {
                return new ConfirmDeleteNPCScreen(data[0]);
            }
            case NPCChatEditor: {
                return new ChattingNPCEditorScreen(data[0]);
            }
            case NPCChat: {
                return new ChattingNPCScreen(data[0]);
            }
            case NPCQuestGiverEditor: {
                return new QuestGiverNPCEditorScreen(data[0]);
            }
            case NPCQuestGiver: {
                return new QuestGiverNPCScreen(data[0]);
            }
            case Relearner: {
                return new RelearnerScreen(ClientStorageManager.party.get(data[0]));
            }
            case Tutor: {
                return new TutorScreen(ClientStorageManager.party.get(data[0]), data[1]);
            }
            case TutorEditor: {
                return new TutorEditorScreen(data[0]);
            }
            case HealerNurseJoy: {
                return new HealerScreen(data[0]);
            }
            case Shopkeeper: {
                return new ShopkeeperScreen(data[0]);
            }
            case ShopkeeperEditor: {
                return new ShopkeeperEditorScreen(data[0]);
            }
            case VendingMachine: {
                return new VendingMachineScreen(new BlockPos(data[0], data[1], data[2]));
            }
            case PokemonEditor: {
                return new PokemonEditorPartyScreen();
            }
            case EditedPlayer: {
                return new EditedPlayerScreen();
            }
            case MegaItem: {
                return new MegaItemScreen(data.length != 0);
            }
            case BattleRulesPlayer: {
                return new BattleRulesPlayerScreen(data[0], data[1] == 1);
            }
            case BattleRulesFixed: {
                return new BattleRulesFixedScreen();
            }
            case TeamSelect: {
                return new TeamSelectScreen();
            }
            case Mail: {
                return new MailScreen(player.func_184586_b(Hand.values()[data[0]]));
            }
            case SelectMove: {
                return new SelectMoveScreen(data[0], data[1]);
            }
            case ShinyCharm: {
                return new CharmScreen(EnumCharms.Shiny);
            }
            case OvalCharm: {
                return new CharmScreen(EnumCharms.Oval);
            }
            case ExpCharm: {
                return new CharmScreen(EnumCharms.Exp);
            }
            case CatchingCharm: {
                return new CharmScreen(EnumCharms.Catching);
            }
            case MarkCharm: {
                return new CharmScreen(EnumCharms.Mark);
            }
            case BottleCap: {
                return new SelectStatScreen(data);
            }
            case CurryDex: {
                return new CurryDexScreen(data);
            }
            case FishingLog: {
                return new FishingLogScreen(data[0], Arrays.copyOfRange(data, 1, data.length));
            }
            case FishingLogMenu: {
                return new FishingLogMenuScreen(data);
            }
            case FishingLogInformation: {
                return new FishingLogInformationScreen(data[0], data[1], data[2], data);
            }
            case ZygardeAssembly: {
                return new ZygardeReassemblyUnitScreen(data[0], data[1], data[2]);
            }
            case ZygardeCube: {
                return new ZygardeCubeScreen(Hand.values()[data[0]], data[1]);
            }
            case QuestEditor: {
                return new QuestEditorScreen();
            }
            case EggHatch: {
                return new EggHatchingScreen(data[0]);
            }
        }
        return null;
    }

    public static File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (Minecraft.func_71410_x().func_147104_D() == null || !ClientProxy.getRichPresence().isAcknowledgedServer()) {
            ClientProxy.getRichPresence().onJoin();
        }
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ClientProxy.battleManager.battleEnded = true;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        Pixelmon.freeze = false;
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    @SubscribeEvent
    public void onPreClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft instance = Minecraft.func_71410_x();
        if (instance.field_71441_e == null || instance.func_147113_T() || toast != null || !instance.field_71474_y.field_244601_E) {
            return;
        }
        GraphicsConfig graphicsConfig = PixelmonConfigProxy.getGraphics();
        if (graphicsConfig.shouldSendToasts()) {
            toast = new ExpandingTutorialToast((ITextComponent)new TranslationTextComponent("pixelmon.tutorial.send.out"), (ITextComponent)new TranslationTextComponent("pixelmon.tutorial.send.out.desc", new Object[]{SEND_POKEMON_KEY.getKey().func_237520_d_().getString().toUpperCase(Locale.ROOT)}));
            instance.func_193032_ao().func_244698_a((TutorialToast)toast, 600);
            graphicsConfig.setShouldSendToasts(false);
            graphicsConfig.save();
        }
    }

    public static void spawnParticle(EnumPixelmonParticles particle, ClientWorld worldObj, double posX, double posY, double posZ, boolean isShiny) {
        try {
            if (particle.particleClass != ParticleGastly.class) {
                Particle fx = particle.particleClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void spawnParticle(EnumBreedingParticles particle, World worldObj, double posX, double posY, double posZ, PaletteProperties paletteProperties) {
    }

    public static void registerTickHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new InventoryDetectionTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)battleManager);
    }

    public static ResourceLocation bindPlayerTexture(String username) {
        if (username.isEmpty() || invaildSkins.contains(username)) {
            return DefaultPlayerSkin.func_177335_a();
        }
        if (cachedSkins.containsKey(username)) {
            return cachedSkins.get(username);
        }
        GameProfile profile = new GameProfile(null, username);
        if ((profile = SkullTileEntity.func_174884_b((GameProfile)profile)).isComplete() && profile.getId().version() == 4 && profile.getProperties().containsKey((Object)"textures")) {
            ResourceLocation resourcelocation;
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                cachedSkins.put(username, resourcelocation);
            } else {
                resourcelocation = DefaultPlayerSkin.func_177335_a();
            }
            return resourcelocation;
        }
        invaildSkins.add(username);
        return DefaultPlayerSkin.func_177335_a();
    }

    public static boolean resourceLocationExists(ResourceLocation resourceLocation) {
        return Minecraft.func_71410_x().func_195551_G().func_219533_b(resourceLocation);
    }

    public static BufferedInputStream getStreamForResourceLocation(ResourceLocation resourceLocation) {
        try {
            return new BufferedInputStream(Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation).func_199027_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void scheduleNextTick(Callable<?> callable) {
        Minecraft.func_71410_x().execute(() -> {
            try {
                callable.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void spawnBoostedTreeParticles(World worldObj, int x, int y, int z, int stage) {
        for (int i = 0; i < 20; ++i) {
            float yplus = worldObj.field_73012_v.nextFloat();
            if (stage <= 3) {
                yplus *= 2.0f;
            }
            ClientProxy.spawnParticle(EnumPixelmonParticles.shiny, (ClientWorld)worldObj, (double)((float)x + worldObj.field_73012_v.nextFloat()), (double)((float)y + yplus), (double)((float)z + worldObj.field_73012_v.nextFloat()), true);
        }
    }

    public static ArrayList<MoveSkill> getMoveSkills(Pokemon pokemon) {
        ArrayList moveSkills = Lists.newArrayList(ClientProxy.moveSkills);
        moveSkills.removeIf(moveSkill -> !moveSkill.hasMoveSkill(pokemon));
        return moveSkills;
    }

    public static PixelmonRichPresence getRichPresence() {
        return richPresence;
    }

    public static ExpandingTutorialToast getToast() {
        return toast;
    }

    static {
        toast = null;
        IReloadableResourceManager manager = (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
        manager.func_219534_a((IFutureReloadListener)new WallpapersListener());
        manager.func_219534_a((IFutureReloadListener)new ResourceLoader());
        manager.func_219534_a((IFutureReloadListener)new SearchTreeExtender());
        cachedSkins = new ConcurrentHashMap();
        invaildSkins = Lists.newArrayList();
    }
}

