/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.blocks.CloningCompleteEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.machines.CloningMachineBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.DecorativeBaseTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class CloningMachineTileEntity
extends DecorativeBaseTileEntity
implements ITickableTileEntity {
    public boolean processingClone = false;
    public boolean growingPokemon = false;
    public boolean isBroken = false;
    public float xboost = 0.0f;
    public float zboost = 0.0f;
    public PixelmonEntity pixelmon;
    public String pokemonName = "";
    public boolean isShiny = false;
    public Pokemon mew = null;
    public UUID owner = null;
    public int boostLevel = 0;
    public int boostCount = 0;
    public float lasPos = -2.0f;
    public int pokemonProgress = 0;
    public boolean isFinished = false;
    boolean boostSet = false;
    boolean travDown = true;
    int baseCount = 0;

    public CloningMachineTileEntity() {
        super((TileEntityType<? extends DecorativeBaseTileEntity>)((TileEntityType)TileEntityRegistration.CLONING_MACHINE.get()));
    }

    private void resetMachine() {
        this.mew = null;
        this.owner = null;
        this.isFinished = false;
        this.growingPokemon = false;
        this.processingClone = false;
        this.isShiny = false;
        this.pokemonProgress = 0;
        this.boostLevel = 0;
        this.boostCount = 0;
        this.baseCount = 0;
        this.pokemonName = "";
        ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
    }

    public void func_73660_a() {
        if (!this.boostSet) {
            Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)CloningMachineBlock.FACING);
            if (direction == Direction.NORTH) {
                this.xboost = (float)((double)this.xboost + 3.35);
            } else if (direction == Direction.SOUTH) {
                this.xboost = (float)((double)this.xboost - 3.35);
            } else {
                this.zboost = direction == Direction.EAST ? (float)((double)this.zboost + 3.35) : (float)((double)this.zboost - 3.35);
            }
            this.boostSet = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.processingClone && this.boostCount == 3 && this.hasMew()) {
                if (this.baseCount < 30) {
                    ++this.baseCount;
                } else if (this.baseCount == 30) {
                    this.processingClone = true;
                    this.baseCount = 0;
                    ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
                }
            }
            if (this.processingClone) {
                ++this.baseCount;
                if (this.baseCount >= 280) {
                    boolean madeMewtwo = Math.random() < (double)((float)this.boostLevel / 40.0f);
                    this.pixelmon = madeMewtwo ? new PixelmonEntity(this.field_145850_b, PokemonFactory.create(PixelmonSpecies.MEWTWO.getValueUnsafe())) : new PixelmonEntity(this.field_145850_b, PokemonFactory.create(PixelmonSpecies.DITTO.getValueUnsafe()));
                    this.pixelmon.initAnimation();
                    boolean bl = this.isShiny = PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()));
                    if (this.isShiny) {
                        this.pixelmon.getPokemon().setShiny();
                    }
                    this.pokemonName = this.pixelmon.getPokemonName();
                    ++((MewStats)this.mew.getExtraStats()).numCloned;
                    this.growingPokemon = true;
                    this.processingClone = false;
                    ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
                }
            }
            if (this.growingPokemon) {
                if (this.pokemonProgress < 200) {
                    ++this.pokemonProgress;
                } else if (!Pixelmon.EVENT_BUS.post((Event)new CloningCompleteEvent(this.mew, this.pixelmon, (PlayerEntity)(this.owner != null ? StorageProxy.getParty(this.owner).getPlayer() : this.mew.getOwnerPlayer()), this.field_174879_c))) {
                    if (this.owner != null) {
                        StorageProxy.getParty(this.owner).add(this.mew);
                    }
                    this.mew = null;
                    this.owner = null;
                    if (this.pokemonName.equals("Mewtwo")) {
                        this.isBroken = true;
                        this.releasePokemon();
                    } else {
                        this.isFinished = true;
                    }
                    this.growingPokemon = false;
                    ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
                } else {
                    --((MewStats)this.mew.getExtraStats()).numCloned;
                    StorageProxy.getParty(this.owner).add(this.mew);
                    this.resetMachine();
                }
            }
        } else {
            if (this.travDown) {
                this.lasPos -= 0.1f;
                if (this.lasPos < -15.0f) {
                    this.travDown = false;
                }
            } else {
                this.lasPos += 0.1f;
                if (this.lasPos >= -2.0f) {
                    this.travDown = true;
                }
            }
            if (this.growingPokemon && this.pokemonProgress < 200) {
                ++this.pokemonProgress;
            }
            if (this.processingClone) {
                ++this.baseCount;
                if (this.baseCount > 80 && this.baseCount < 280) {
                    int i = 0;
                    while ((float)i < 30.0f * ((float)this.baseCount - 80.0f) / 200.0f) {
                        WorldHelper.spawnRedstoneParticle(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + this.xboost + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + 0.3f + this.field_145850_b.field_73012_v.nextFloat() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177952_p() + this.zboost + this.field_145850_b.field_73012_v.nextFloat(), -255.0, 1.0, 255.0);
                        ++i;
                    }
                }
            }
        }
        if (this.pokemonName.equals("") && this.pixelmon != null) {
            this.pixelmon = null;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.boostCount = nbt.func_74765_d("BoostCount");
        this.boostLevel = nbt.func_74765_d("BoostLevel");
        this.isBroken = nbt.func_74767_n("IsBroken");
        this.isFinished = nbt.func_74767_n("IsFinished");
        this.processingClone = nbt.func_74767_n("ProcessingClone");
        this.growingPokemon = nbt.func_74767_n("GrowingPokemon");
        this.pokemonName = nbt.func_74779_i("PokemonName");
        this.baseCount = nbt.func_74762_e("BaseCount");
        this.pokemonProgress = nbt.func_74762_e("PokemonProgress");
        this.mew = nbt.func_74764_b("Mew") ? PokemonFactory.create(nbt.func_74775_l("Mew")) : null;
        this.owner = nbt.func_186855_b("Owner") ? nbt.func_186857_a("Owner") : null;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("BoostCount", (short)this.boostCount);
        nbt.func_74777_a("BoostLevel", (short)this.boostLevel);
        nbt.func_74757_a("IsBroken", this.isBroken);
        nbt.func_74757_a("IsFinished", this.isFinished);
        nbt.func_74757_a("ProcessingClone", this.processingClone);
        nbt.func_74757_a("GrowingPokemon", this.growingPokemon);
        nbt.func_74778_a("PokemonName", this.pokemonName);
        nbt.func_74768_a("BaseCount", this.baseCount);
        if (this.hasMew()) {
            CompoundNBT mewnbt = new CompoundNBT();
            this.mew.writeToNBT(mewnbt);
            nbt.func_218657_a("Mew", (INBT)mewnbt);
        }
        if (this.owner != null) {
            nbt.func_186854_a("Owner", this.owner);
        }
        nbt.func_74768_a("PokemonProgress", this.pokemonProgress);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public boolean hasMew() {
        return this.mew != null;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void activate(PlayerEntity player, ItemStack heldItem) {
        if (!PixelmonConfigProxy.getGeneral().isCloningMachineEnabled()) {
            ChatHandler.sendChat((Entity)player, "pixelmon.general.disabledblock", new Object[0]);
            return;
        }
        if (this.isBroken) {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.clone.broken", new Object[0]);
            return;
        }
        if (this.isFinished) {
            PlayerPartyStorage storage = StorageProxy.getParty((ServerPlayerEntity)player);
            if (storage.countAblePokemon() < 1) {
                this.releasePokemon();
            } else {
                this.fightDitto((ServerPlayerEntity)player, storage);
            }
            this.resetMachine();
        } else if (!this.hasMew()) {
            PlayerPartyStorage storage = StorageProxy.getParty((ServerPlayerEntity)player);
            if (storage.inTemporaryMode()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.intemporarymode", new Object[0]);
                return;
            }
            if (storage.countPokemon() > 1) {
                Pokemon mew = storage.findOne(pokemon -> pokemon.getSpecies().is(PixelmonSpecies.MEW) && ((MewStats)pokemon.getExtraStats()).numCloned < 3);
                if (mew != null) {
                    this.mew = mew;
                    storage.set((StoragePosition)mew.getStorageAndPosition().func_76340_b(), null);
                    mew.setStorage(null, null);
                    mew.retrieve("BlockInteract");
                    this.owner = storage.getIdentifier();
                    ((ServerWorld)player.field_70170_p).func_72863_F().func_217217_a(this.field_174879_c);
                } else {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.noclone", new Object[0]);
                }
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.lastpoke", new Object[0]);
            }
        } else if (this.hasMew() && player.func_225608_bj_() && !this.growingPokemon && !this.processingClone) {
            if (this.owner != null) {
                StorageProxy.getParty(this.owner).add(this.mew);
                this.resetMachine();
            }
        } else if (this.boostCount < 3 && heldItem != null && heldItem.func_77973_b() instanceof BlockItem) {
            Block block = ((BlockItem)heldItem.func_77973_b()).func_179223_d();
            if (block == Blocks.field_150339_S) {
                ++this.boostCount;
                ++this.boostLevel;
                ((ServerWorld)player.field_70170_p).func_72863_F().func_217217_a(this.field_174879_c);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
            } else if (block == Blocks.field_150340_R) {
                ++this.boostCount;
                this.boostLevel += 3;
                ((ServerWorld)player.field_70170_p).func_72863_F().func_217217_a(this.field_174879_c);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
            } else if (block == Blocks.field_150484_ah) {
                ++this.boostCount;
                this.boostLevel += 5;
                ((ServerWorld)player.field_70170_p).func_72863_F().func_217217_a(this.field_174879_c);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
            }
        }
    }

    private void fightDitto(ServerPlayerEntity player, PlayerPartyStorage storage) {
        if (this.pixelmon == null) {
            return;
        }
        PixelmonEntity firstPokemon = storage.findOne(Pokemon::canBattle).getOrSpawnPixelmon((Entity)player);
        firstPokemon.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, 0.0f);
        WildPixelmonParticipant part = new WildPixelmonParticipant(this.pixelmon);
        this.pixelmon.startBattle(new PlayerParticipant(player, firstPokemon), part);
    }

    public void releasePokemon() {
        int xplus = 0;
        int zplus = 0;
        if (this.xboost > 0.0f) {
            ++zplus;
        } else if (this.xboost < 0.0f) {
            --zplus;
        } else if (this.zboost > 0.0f) {
            --xplus;
        } else if (this.zboost < 0.0f) {
            ++xplus;
        }
        if (this.pixelmon != null) {
            this.pixelmon.func_70012_b((float)this.field_174879_c.func_177958_n() + this.xboost + (float)xplus, this.field_174879_c.func_177956_o(), (float)this.field_174879_c.func_177952_p() + this.zboost + (float)zplus, 0.0f, 0.0f);
            this.field_145850_b.func_217376_c((Entity)this.pixelmon);
        }
    }

    public void onDestroy() {
        if (!this.field_145850_b.field_72995_K && this.hasMew()) {
            try {
                PlayerPartyStorage storage = StorageProxy.getParty(this.owner);
                if (storage != null) {
                    storage.add(this.mew);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

