/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class PixelmonGrassBlock
extends Block
implements IGrowable,
IForgeShearable,
IPlantable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public PixelmonGrassBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(3.0f).func_200947_a(SoundType.field_185850_c).func_200942_a().func_200944_c());
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    protected boolean canPlaceBlockOn(Block ground) {
        Material groundMaterial = ground.func_176223_P().func_185904_a();
        return groundMaterial == Material.field_151578_c || groundMaterial == Material.field_151595_p || groundMaterial == Material.field_151577_b;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entityIn;
            if (BattleRegistry.getBattle((PlayerEntity)player) != null) {
                return;
            }
            PlayerPartyStorage storage = StorageProxy.getParty(player);
            if (storage.getTicksTillEncounter() <= 1 && player.func_226278_cu_() == (double)pos.func_177956_o()) {
                BlockSpawningHandler.getInstance().performBattleStartCheck(worldIn, pos, (Entity)player, null, BattleStartTypes.PUGRASSSINGLE, state, new Object[0]);
            }
            storage.updateTicksTillEncounter();
        }
    }

    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        return true;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new ItemStack((IItemProvider)PixelmonBlocks.pixelmon_grass, 1));
        return ret;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.checkAndDropBlock((World)worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, BlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)BlockRegistration.getItemFromBlock(this))));
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, BlockState state) {
        BlockPos down = pos.func_177977_b();
        Block soil = worldIn.func_180495_p(down).func_177230_c();
        if (state.func_177230_c() != this) {
            return this.canPlaceBlockOn(soil);
        }
        return soil.canSustainPlant(state, (IBlockReader)worldIn, down, Direction.UP, (IPlantable)this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }
}

