/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.FossilMachineEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.tileentity.FossilMachineTileEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import com.pixelmonmod.pixelmon.items.FossilItem;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class FossilMachineBlock
extends MultiBlock {
    public FossilMachineBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_226896_b_().func_200943_b(1.0f), 1, 2.0, 1);
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        FossilMachineTileEntity machine;
        if (state.func_177229_b(MultiBlock.MULTIPOS) == MultiBlockPosition.BASE && (machine = BlockHelper.getTileEntity(FossilMachineTileEntity.class, (IBlockReader)world, pos)) != null && machine.fossilProgress > 1.0f && machine.pokemonProgress < 3200.0f) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187812_eh, SoundCategory.BLOCKS, 0.01f, random.nextFloat() * 0.4f + 0.8f, true);
        }
    }

    public void capturePokemonInMachine(World world, BlockPos pos, PlayerEntity player) {
        FossilMachineTileEntity tile = (FossilMachineTileEntity)world.func_175625_s(pos);
        if (tile != null) {
            PokemonSpecification spec = PokemonSpecificationProxy.create(tile.currentPokemon + " pokemonLevel:1");
            Pokemon pokemon = spec.create();
            pokemon.setPalette(tile.isShiny ? "shiny" : "");
            pokemon.setBall(tile.pokeball);
            boolean hasSummer = false;
            for (Pokemon p : StorageProxy.getParty((ServerPlayerEntity)player).getTeam()) {
                if (p == null || !p.isPalette("summer")) continue;
                hasSummer = true;
            }
            if (hasSummer && pokemon.hasPalette("summer")) {
                pokemon.setPalette("summer");
            }
            if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent((ServerPlayerEntity)player, pokemon, "Fossil"))) {
                return;
            }
            StorageProxy.getParty((ServerPlayerEntity)player).add(pokemon);
            pokemon.setFriendship(pokemon.getForm().getSpawn().getBaseFriendship());
            ((ServerWorld)world).func_72863_F().func_217217_a(pos);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean obtainedPokemon;
        if (world.func_201670_d() || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        pos = this.findBaseBlock((IBlockReader)world, pos.func_239590_i_(), state);
        FossilMachineTileEntity tile = BlockHelper.getTileEntity(FossilMachineTileEntity.class, (IBlockReader)world, pos);
        ServerChunkProvider playerChunkMap = ((ServerWorld)world).func_72863_F();
        Item heldItemType = null;
        if (!heldItem.func_190926_b()) {
            heldItemType = heldItem.func_77973_b();
        }
        boolean heldItemIsFossil = heldItemType instanceof FossilItem;
        boolean heldItemIsPokeBall = heldItemType instanceof PokeBallItem;
        boolean bl = obtainedPokemon = tile.pokeball != null && tile.pokemonOccupied && tile.pokemonProgress == 3200.0f;
        if (!obtainedPokemon) {
            FossilMachineEvent.RemovePokeball event;
            if (tile.pokeball != null && !heldItemIsFossil && !Pixelmon.EVENT_BUS.post((Event)(event = new FossilMachineEvent.RemovePokeball((ServerPlayerEntity)player, tile.pokeball, tile)))) {
                DropItemHelper.giveItemStack((ServerPlayerEntity)player, event.getPokeball().getBallItem(), false);
                tile.pokeball = null;
            }
            EnumFossils prevFossil = tile.currentFossil;
            if (tile.currentFossil != null && !heldItemIsPokeBall) {
                boolean dropExisting;
                boolean bl2 = dropExisting = prevFossil != EnumFossils.NULL;
                if (heldItemIsFossil) {
                    FossilItem itemFossil = (FossilItem)heldItemType;
                    if (tile.currentFossil == EnumFossils.BIRD) {
                        if (itemFossil.fossil == EnumFossils.DRAKE) {
                            tile.currentFossil = EnumFossils.DZ;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.DINO) {
                            tile.currentFossil = EnumFossils.AZ;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                    }
                    if (tile.currentFossil == EnumFossils.FISH) {
                        if (itemFossil.fossil == EnumFossils.DRAKE) {
                            tile.currentFossil = EnumFossils.DV;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.DINO) {
                            tile.currentFossil = EnumFossils.AV;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                    }
                    if (tile.currentFossil == EnumFossils.DRAKE) {
                        if (itemFossil.fossil == EnumFossils.FISH) {
                            tile.currentFossil = EnumFossils.DV;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.BIRD) {
                            tile.currentFossil = EnumFossils.DZ;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                    }
                    if (tile.currentFossil == EnumFossils.DINO) {
                        if (itemFossil.fossil == EnumFossils.FISH) {
                            tile.currentFossil = EnumFossils.AV;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.BIRD) {
                            tile.currentFossil = EnumFossils.AZ;
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            playerChunkMap.func_217217_a(pos);
                            dropExisting = false;
                        }
                    }
                }
                if (dropExisting) {
                    FossilMachineEvent.RemoveFossil event2;
                    EnumFossils[] fossilItems = new EnumFossils[2];
                    if (prevFossil.getIndex() < -1) {
                        switch (prevFossil) {
                            default: {
                                break;
                            }
                            case AV: {
                                fossilItems[0] = EnumFossils.FISH;
                                fossilItems[1] = EnumFossils.DINO;
                                break;
                            }
                            case AZ: {
                                fossilItems[0] = EnumFossils.BIRD;
                                fossilItems[1] = EnumFossils.DINO;
                                break;
                            }
                            case DV: {
                                fossilItems[0] = EnumFossils.FISH;
                                fossilItems[1] = EnumFossils.DRAKE;
                                break;
                            }
                            case DZ: {
                                fossilItems[0] = EnumFossils.DRAKE;
                                fossilItems[1] = EnumFossils.BIRD;
                                break;
                            }
                        }
                    } else {
                        fossilItems[0] = prevFossil;
                        fossilItems[1] = null;
                    }
                    if (!Pixelmon.EVENT_BUS.post((Event)(event2 = new FossilMachineEvent.RemoveFossil((ServerPlayerEntity)player, fossilItems, tile)))) {
                        for (EnumFossils fossilItem : fossilItems) {
                            if (fossilItem == null) continue;
                            DropItemHelper.giveItemStack((ServerPlayerEntity)player, new ItemStack((IItemProvider)fossilItem.getItem()), false);
                        }
                        tile.currentFossil = EnumFossils.NULL;
                        tile.fossilProgress = 0.0f;
                        tile.pokemonProgress = 0.0f;
                    }
                }
            }
            if (!heldItem.func_190926_b()) {
                if (heldItemIsPokeBall && tile.pokeball == null) {
                    PokeBall pokeballToPut = PokeBallPart.getPokeBall(player.func_184614_ca()).get();
                    if (!Pixelmon.EVENT_BUS.post((Event)new FossilMachineEvent.PutPokeball((ServerPlayerEntity)player, pokeballToPut, tile))) {
                        tile.pokeball = pokeballToPut;
                        heldItem.func_190918_g(1);
                        playerChunkMap.func_217217_a(pos);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (heldItemIsFossil && tile.currentFossil == EnumFossils.NULL && !tile.pokemonOccupied && prevFossil == EnumFossils.NULL) {
                    FossilMachineEvent.PutFossil event3 = new FossilMachineEvent.PutFossil((ServerPlayerEntity)player, heldItem.func_77973_b(), tile);
                    if (!Pixelmon.EVENT_BUS.post((Event)event3)) {
                        tile.currentFossil = ((FossilItem)heldItemType).fossil;
                        if (!player.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                        playerChunkMap.func_217217_a(pos);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        if (obtainedPokemon) {
            this.capturePokemonInMachine(world, pos, player);
        }
        if (obtainedPokemon || !tile.pokemonOccupied && !heldItemIsFossil && !heldItemIsPokeBall) {
            tile.pokemonOccupied = false;
            tile.fossilProgress = 0.0f;
            tile.pokemonProgress = 0.0f;
            tile.currentFossil = EnumFossils.NULL;
            tile.currentPokemon = "";
            tile.pokeball = null;
            tile.completionRate = 0;
            playerChunkMap.func_217217_a(pos);
            return ActionResultType.SUCCESS;
        }
        playerChunkMap.func_217217_a(pos);
        return ActionResultType.FAIL;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @Override
    protected Optional<TileEntity> getTileEntity(IBlockReader world, BlockState state) {
        return Optional.of(new FossilMachineTileEntity());
    }
}

