/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.blocks.tileentity.ScrollTileEntity;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ScrollBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)15);
    protected static final VoxelShape STANDING_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75));

    public ScrollBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_().func_200947_a(SoundType.field_185848_a));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, ROTATION});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public boolean isPassable(IWorld worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ScrollTileEntity(Type.WATERS);
    }

    private ItemStack getTileDataItemStack(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        return te instanceof ScrollTileEntity ? ((ScrollTileEntity)te).getItem() : ItemStack.field_190927_a;
    }

    public ItemStack getItem(World worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = this.getTileDataItemStack(worldIn, pos);
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_196206_ev) : itemstack;
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return !this.hasInvalidNeighbor(worldIn, pos);
    }

    protected boolean isInvalidNeighbor(World worldIn, BlockPos pos, Direction facing) {
        return worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof ScrollBlock;
    }

    protected boolean hasInvalidNeighbor(World worldIn, BlockPos pos) {
        return this.isInvalidNeighbor(worldIn, pos, Direction.NORTH) || this.isInvalidNeighbor(worldIn, pos, Direction.SOUTH) || this.isInvalidNeighbor(worldIn, pos, Direction.WEST) || this.isInvalidNeighbor(worldIn, pos, Direction.EAST);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            if (te instanceof ScrollTileEntity) {
                ScrollTileEntity scroll = (ScrollTileEntity)te;
                scroll.func_145843_s();
                ScrollBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)scroll.getItem());
            } else {
                super.func_180657_a(worldIn, player, pos, state, null, stack);
            }
        } else {
            super.func_180657_a(worldIn, player, pos, state, null, stack);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ScrollTileEntity) {
            ScrollTileEntity scroll = (ScrollTileEntity)te;
            return scroll.getItem();
        }
        return ItemStack.field_190927_a;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static enum Type implements ITranslatable
    {
        WATERS("scroll_of_waters", "pixelmon:textures/entity/scroll/scroll_of_waters.png"),
        DARKNESS("scroll_of_darkness", "pixelmon:textures/entity/scroll/scroll_of_darkness.png");

        private final String name;
        private final String defaultResource;

        private Type(String name, String defaultResource) {
            this.name = name;
            this.defaultResource = defaultResource;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultResource() {
            return this.defaultResource;
        }

        @Override
        public String getTranslationKey() {
            return "block.pixelmon." + this.getName();
        }

        @Override
        public String getLocalizedName() {
            return new TranslationTextComponent(this.getTranslationKey()).getString();
        }
    }

    public static class ScrollBlockStanding
    extends ScrollBlock {
        public ScrollBlockStanding() {
            this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(0));
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
            return STANDING_AABB;
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
        }

        public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
            if (!worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)BlockRegistration.getItemFromBlock((Block)this))));
                worldIn.func_217377_a(pos, false);
            }
            super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        }
    }

    public static class ScrollBlockHanging
    extends ScrollBlock {
        protected static final VoxelShape NORTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0));
        protected static final VoxelShape SOUTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125));
        protected static final VoxelShape WEST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0));
        protected static final VoxelShape EAST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0));

        public ScrollBlockHanging() {
            this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            switch (direction) {
                default: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
        }

        public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
            Direction enumfacing = (Direction)state.func_177229_b((Property)FACING);
            if (!worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_185904_a().func_76220_a()) {
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)BlockRegistration.getItemFromBlock((Block)this))));
                worldIn.func_217377_a(pos, false);
            }
            super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        }
    }
}

