/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.drops.CustomDropScreenFactory;
import com.pixelmonmod.pixelmon.api.enums.PositionTriState;
import com.pixelmonmod.pixelmon.api.events.PokeStopEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeStopTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.network.IPacket;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class PokeStopBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private Color color;
    private ResourceLocation lootTable;

    public PokeStopBlock(Color color, ResourceLocation lootTable) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_200948_a(-1.0f, 6000000.0f));
        this.color = color;
        this.lootTable = lootTable;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        LootContext.Builder lootcontext$builder;
        LootContext ctx;
        if (world.func_201670_d() || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof PokeStopTileEntity)) {
            return ActionResultType.SUCCESS;
        }
        PokeStopTileEntity pokestop = (PokeStopTileEntity)tileEntity;
        UUID playerID = player.func_110124_au();
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        PokeStopEvent.CooldownCheck.Pre cooldownCheckPre = new PokeStopEvent.CooldownCheck.Pre(playerMP, pokestop);
        if (Pixelmon.EVENT_BUS.post((Event)cooldownCheckPre)) {
            return ActionResultType.SUCCESS;
        }
        if (cooldownCheckPre.isShouldCheckCooldown() && !pokestop.canClaim((PlayerEntity)playerMP)) {
            if (pokestop.isOneTimeUse()) {
                ChatHandler.sendChat((Entity)player, "block.pixelmon.claimedpokestop", new Object[0]);
            } else {
                ChatHandler.sendChat((Entity)player, "block.pixelmon.timedpokestop", new Object[0]);
            }
            return ActionResultType.SUCCESS;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.CooldownCheck.PostCalculate(playerMP, pokestop))) {
            return ActionResultType.SUCCESS;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.CooldownCheck.Post(playerMP, pokestop))) {
            return ActionResultType.SUCCESS;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.Use.Pre(playerMP, pokestop))) {
            return ActionResultType.SUCCESS;
        }
        LootTable loottable = world.func_73046_m().func_200249_aQ().func_186521_a(pokestop.getLootTable());
        List<ItemStack> drops = loottable.func_216113_a(ctx = (lootcontext$builder = this.createLootContext(world, state, playerMP, pokestop)).func_216022_a(LootParameterSets.field_216260_a));
        PokeStopEvent.Drops.Pre getDropsEvent = new PokeStopEvent.Drops.Pre(playerMP, pokestop, drops);
        if (!Pixelmon.EVENT_BUS.post((Event)getDropsEvent)) {
            drops = getDropsEvent.getDrops();
            ItemStack firstDrop = ItemStack.field_190927_a;
            CustomDropScreenFactory.builder().setTitle((ITextComponent)new TranslationTextComponent("block.pixelmon.pokestop")).addItems(drops).escapeDoesNotClose().dropHandler((clickDrop, itemStack) -> DropItemHelper.giveItemStack((ServerPlayerEntity)player, itemStack, false)).setButtonText(PositionTriState.CENTER, (ITextComponent)new TranslationTextComponent("block.pixelmon.pokestop.exit")).sendTo(playerMP);
            String itemName = drops.size() == 0 || firstDrop.func_190926_b() ? "tile.pokestop" : firstDrop.func_77973_b().func_77667_c(firstDrop) + "";
            ChatHandler.sendChat((Entity)player, "block.pixelmon.pokestop.use", new TranslationTextComponent(itemName));
            Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.Drops.Post(playerMP, pokestop, drops));
        }
        pokestop.removeClaimer(playerID);
        pokestop.addClaimer(playerID);
        pokestop.func_70296_d();
        pokestop.func_145831_w().func_175646_b(pokestop.func_174877_v(), (TileEntity)pokestop);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)pokestop.func_189518_D_());
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)SoundRegistration.POKELOOT_OBTAINED.get(), SoundCategory.BLOCKS, 0.2f, 1.0f);
        Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.Use.Post(playerMP, pokestop));
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        PokeStopTileEntity tileEntity = new PokeStopTileEntity();
        tileEntity.setLootTable(this.lootTable);
        tileEntity.setColor(this.color);
        return tileEntity;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te = world.func_175625_s(pos);
        float scale = 1.0f;
        if (te instanceof PokeStopTileEntity) {
            scale = ((PokeStopTileEntity)te).getScale();
        }
        float dXZ = 0.1f * scale;
        AxisAlignedBB aabb = new AxisAlignedBB((double)(0.5f - dXZ), 0.0, (double)(0.5f - dXZ), (double)(0.5f + dXZ), (double)(1.5f * scale), (double)(0.5f + dXZ));
        return VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
    }

    protected LootContext.Builder createLootContext(World world, BlockState state, ServerPlayerEntity player, PokeStopTileEntity pokestop) {
        BlockPos pos = pokestop.func_174877_v();
        return new LootContext.Builder((ServerWorld)world).func_216023_a(RandomHelper.getRandom()).func_216015_a(LootParameters.field_216288_h, (Object)pokestop).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184614_ca()).func_216015_a(LootParameters.field_216284_d, (Object)player).func_216015_a(LootParameters.field_216285_e, (Object)player).func_216015_a(LootParameters.field_216282_b, (Object)player).func_186469_a(player.func_184817_da());
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean func_208619_r() {
        return true;
    }
}

