/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.OrbTileEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumOrbShard;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class OrbBlock
extends GenericRotatableModelBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.7, 0.8);
    public final EnumOrbShard shardType;

    public OrbBlock(EnumOrbShard shardType) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185853_f));
        this.shardType = shardType;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch (this.shardType) {
            case RED: {
                return new ItemStack((IItemProvider)PixelmonItems.red_orb);
            }
            case BLUE: {
                return new ItemStack((IItemProvider)PixelmonItems.blue_orb);
            }
            case JADE: {
                return new ItemStack((IItemProvider)PixelmonItems.jade_orb);
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        OrbTileEntity tile = (OrbTileEntity)world.func_175625_s(pos);
        if (tile == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (player.func_184812_l_()) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        byte pieces = tile.getPieces();
        ItemStack stack = null;
        if (this.shardType == EnumOrbShard.RED) {
            stack = pieces == 10 ? new ItemStack((IItemProvider)PixelmonItems.red_orb, 1) : new ItemStack((IItemProvider)PixelmonItems.omega_shard, (int)pieces);
        } else if (this.shardType == EnumOrbShard.BLUE) {
            stack = pieces == 10 ? new ItemStack((IItemProvider)PixelmonItems.blue_orb, 1) : new ItemStack((IItemProvider)PixelmonItems.alpha_shard, (int)pieces);
        } else if (this.shardType == EnumOrbShard.JADE) {
            ItemStack itemStack = stack = pieces == 10 ? new ItemStack((IItemProvider)PixelmonItems.jade_orb, 1) : new ItemStack((IItemProvider)PixelmonItems.delta_shard, (int)pieces);
        }
        if (stack != null && !world.field_72995_K) {
            ItemEntity drops = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
            world.func_217376_c((Entity)drops);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new OrbTileEntity(1);
    }
}

