/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Recharge
extends StatusBase {
    transient int turnWait;
    transient int turnsWaited = 0;

    public Recharge() {
        super(StatusType.Recharge);
        this.turnWait = 1;
    }

    public Recharge(int turnWait) {
        super(StatusType.Recharge);
        this.turnWait = turnWait;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.addStatus(new Recharge(1), user);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (this.turnsWaited > this.turnWait) {
            user.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.recharging", user.getNickname());
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (this.turnsWaited++ >= this.turnWait) {
            pw.removeStatus(this);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        userChoice.weight /= 2.0f;
    }
}

