/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class HealingWish
extends StatusBase {
    public HealingWish() {
        super(StatusType.HealingWish);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.getParticipant().hasMorePokemonReserve()) {
            user.addStatus(new HealingWish(), user);
            user.doBattleDamage(user, user.getHealth(), DamageTypeEnum.SELF);
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public boolean isWholeTeamStatus() {
        return false;
    }

    @Override
    public void applyEffectOnSwitch(PixelmonWrapper pw) {
        boolean didHeal = false;
        if (pw.getMaxHealth() > pw.getHealth()) {
            pw.healEntityBy(pw.getHealthDeficit());
            didHeal = true;
        }
        for (int i = 0; i < pw.getStatusSize(); ++i) {
            StatusType currentStatus = pw.getStatus((int)i).type;
            if (!currentStatus.isPrimaryStatus() && currentStatus != StatusType.HealingWish) continue;
            if (currentStatus != StatusType.HealingWish) {
                didHeal = true;
            }
            pw.removeStatus(i);
            --i;
        }
        if (!didHeal) {
            pw.addStatus(new HealingWish(), pw);
            pw.bc.sendToAll("pixelmon.effect.healfailed", pw.getNickname());
        } else {
            pw.bc.sendToAll("pixelmon.effect.healingwish", new Object[0]);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper outgoing, PixelmonWrapper incoming) {
        outgoing.removeStatus(StatusType.HealingWish);
    }
}

