/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.List;

public class SuckerPunch
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.simulateMode) {
            return AttackResult.proceed;
        }
        if (target.attack != null && target.attack.getAttackCategory() != AttackCategory.STATUS) {
            for (int i = user.bc.turn + 1; i < user.bc.turnList.size(); ++i) {
                if (user.bc.turnList.get(i) != target) continue;
                return AttackResult.proceed;
            }
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        int numOffensive = 0;
        int numStatus = 0;
        for (PixelmonWrapper target : userChoice.targets) {
            for (Attack attack : pw.getBattleAI().getMoveset(target)) {
                if (attack.getAttackCategory() == AttackCategory.STATUS) {
                    ++numStatus;
                    continue;
                }
                ++numOffensive;
            }
        }
        if (numStatus == 0) {
            return;
        }
        if (RandomHelper.getRandomChance((float)numStatus / ((float)numOffensive + (float)numStatus))) {
            userChoice.lowerTier(1);
        }
    }
}

