/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.tiers.HierarchicalTier;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.tiers.Tier;
import java.util.List;

public class BattleTierRegistry {
    private static final List<Tier> TIERS = Lists.newArrayList();
    public static final Tier UNRESTRICTED = BattleClauseRegistry.register(new HierarchicalTier("unrestricted", true, new PokemonSpecification[0]));
    public static final Tier OU = BattleClauseRegistry.register(new HierarchicalTier("ou", true, UNRESTRICTED, new PokemonSpecification[0]));
    public static final Tier UU = BattleClauseRegistry.register(new HierarchicalTier("uu", true, OU, new PokemonSpecification[0]));
    public static final Tier RU = BattleClauseRegistry.register(new HierarchicalTier("ru", true, UU, new PokemonSpecification[0]));
    public static final Tier NU = BattleClauseRegistry.register(new HierarchicalTier("nu", true, RU, new PokemonSpecification[0]));
    public static final Tier PU = BattleClauseRegistry.register(new HierarchicalTier("pu", true, NU, new PokemonSpecification[0]));

    public static <T extends Tier> T addTier(T tier) {
        TIERS.add(tier);
        return tier;
    }

    public static List<Tier> getAllTiers() {
        return TIERS;
    }

    public static Tier getTierWithID(String id) {
        for (Tier tier : TIERS) {
            if (!tier.getID().equalsIgnoreCase(id)) continue;
            return tier;
        }
        return null;
    }

    static {
        TIERS.addAll(Lists.newArrayList((Object[])new Tier[]{UNRESTRICTED, OU, UU, RU, NU, PU}));
    }
}

