/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.world;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.LongPredicate;
import net.minecraft.world.World;

public enum WorldTime implements ITranslatable
{
    DAWN(tick -> tick >= 22500L || tick <= 300L),
    MORNING(tick -> tick <= 6000L || tick >= 22550L),
    DAY(tick -> tick <= 12000L),
    MIDDAY(tick -> tick >= 5500L && tick <= 6500L),
    AFTERNOON(tick -> tick >= 6000L && tick <= 12000L),
    DUSK(tick -> tick >= 12000L && tick <= 13800L),
    NIGHT(tick -> tick >= 13450L && tick <= 22550L),
    MIDNIGHT(tick -> tick >= 17500L && tick <= 18500L);

    private static final WorldTime[] ALL_TIMES;
    private final LongPredicate tickCondition;

    private WorldTime(LongPredicate tickCondition) {
        this.tickCondition = tickCondition;
    }

    public LongPredicate getTickCondition() {
        return this.tickCondition;
    }

    @Override
    public String getTranslationKey() {
        return "pixelmon.time." + this.name().toLowerCase(Locale.ROOT);
    }

    public static List<WorldTime> getCurrent(World world) {
        ArrayList current = Lists.newArrayListWithCapacity((int)ALL_TIMES.length);
        long currentTime = world.func_72820_D() % 24000L;
        for (WorldTime time : ALL_TIMES) {
            if (!time.tickCondition.test(currentTime)) continue;
            current.add(time);
        }
        return current;
    }

    static {
        ALL_TIMES = WorldTime.values();
    }
}

